/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.merge;

import ancestris.modules.releve.merge.MergePanel;
import ancestris.modules.releve.merge.MergeRecord;
import ancestris.modules.releve.merge.ProposalHelper;
import ancestris.modules.releve.merge.SelectionManager;
import ancestris.modules.releve.merge.SourceChooser;
import ancestris.modules.releve.merge.WitnessChooser;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyAssociation;
import genj.gedcom.PropertyChoiceRole;
import genj.gedcom.PropertyMedia;
import genj.gedcom.PropertyMultilineValue;
import genj.gedcom.PropertyQuality;
import genj.gedcom.PropertySource;
import genj.gedcom.Source;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.openide.util.NbBundle;

public abstract class MergeTableAction {
    private static final String showEntityToolTip = NbBundle.getMessage(MergePanel.class, (String)"MergeTable.showEntity.tooltip");
    private static final String showEntityNewToolTip = NbBundle.getMessage(MergePanel.class, (String)"MergeTable.showEntityNew.tooltip");
    private static final String showSourceToolTip = NbBundle.getMessage(MergePanel.class, (String)"MergeTable.showSource.tooltip");
    private static final String sourceCitationSelectionToolTip = NbBundle.getMessage(MergePanel.class, (String)"MergeTable.sourceCitationSelection.tooltip");
    private static final String sourceCitationSelectionEmptyToolTip = NbBundle.getMessage(MergePanel.class, (String)"MergeTable.sourceCitationSelectionEmpty.tooltip");
    private static final String sourceReliabilitySelectionToolTip = NbBundle.getMessage(MergePanel.class, (String)"MergeTable.sourceReliabilitySelection.tooltip");
    private static final String sourceTextSelectionToolTip = NbBundle.getMessage(MergePanel.class, (String)"MergeTable.sourceTextSelection.tooltip");
    private static final String sourceMediaSelectionToolTip = NbBundle.getMessage(MergePanel.class, (String)"MergeTable.sourceMediaSelection.tooltip");
    private static final String associationSelectionToolTip = NbBundle.getMessage(MergePanel.class, (String)"MergeTable.associationSelection.tooltip");
    private static final String associationSelectionEmptyToolTip = NbBundle.getMessage(MergePanel.class, (String)"MergeTable.associationSelectionEmpty.tooltip");
    private static final String associationRoleToolTip = NbBundle.getMessage(MergePanel.class, (String)"MergeTable.associationRoleSelection.tooltip");

    abstract String getText();

    static class WitnessRoleRecordSelection
    extends MergeTableAction {
        protected PropertyChoiceRole m_property;
        protected String m_text;

        WitnessRoleRecordSelection(PropertyChoiceRole property) {
            this.m_property = property;
            this.m_text = property.getDisplayValue();
        }

        PropertyChoiceRole getProperty() {
            return this.m_property;
        }

        @Override
        String getText() {
            return this.m_text;
        }

        String getToolTipText() {
            return associationRoleToolTip;
        }

        void setValue(PropertyChoiceRole prop) {
            this.m_text = prop.getDisplayValue();
        }
    }

    static class WitnessAssociationSelection
    extends MergeTableAction {
        protected PropertyAssociation m_selectedAssociation;
        protected final List<PropertyAssociation> m_existingAssociations;
        protected String m_text;

        WitnessAssociationSelection(PropertyAssociation selectedAssociation, List<PropertyAssociation> existingAssociations) {
            this.m_selectedAssociation = selectedAssociation;
            this.m_existingAssociations = existingAssociations;
        }

        PropertyAssociation getProperty() {
            return this.m_selectedAssociation;
        }

        @Override
        String getText() {
            return this.m_text;
        }

        String getToolTipText() {
            if (this.m_existingAssociations.isEmpty()) {
                return associationSelectionEmptyToolTip;
            }
            return associationSelectionToolTip;
        }
    }

    static interface WitnessUpdateListener {
        public void witnessUpdated(String var1, Indi var2);
    }

    static class WitnessRecordSelection
    extends MergeTableAction {
        private static final String CHANGE_WITNESS = NbBundle.getMessage(MergeTableAction.class, (String)"MergeTable.changeWitness.ToolTip");
        private static final String SELECT_WITNESS = NbBundle.getMessage(MergeTableAction.class, (String)"MergeTable.selectWitness.ToolTip");
        protected Indi m_witness;
        protected String m_text;
        private String m_witnessToolTip;
        private final ProposalHelper m_proposalHelper;
        private final Gedcom m_gedcom;
        protected final MergeRecord.RecordWitness m_recordWitness;
        protected final ArrayList<WitnessUpdateListener> witnessUpdateListeners = new ArrayList();

        WitnessRecordSelection(ProposalHelper proposalHelper, Indi witness, Gedcom gedcom, MergeRecord.RecordWitness recordWitness) {
            this.m_proposalHelper = proposalHelper;
            this.m_gedcom = gedcom;
            this.m_witness = witness;
            this.m_recordWitness = recordWitness;
            this.m_text = recordWitness.getDisplayValue();
            this.m_witnessToolTip = witness == null ? SELECT_WITNESS : CHANGE_WITNESS;
        }

        @Override
        String getText() {
            return this.m_text;
        }

        String getToolTipText() {
            return this.m_witnessToolTip;
        }

        void editAction(Frame parent) {
            WitnessChooser witnessChooser = new WitnessChooser(this.m_recordWitness, this.m_witness, this.m_gedcom);
            String title = NbBundle.getMessage(this.getClass(), (String)"WitnessChooser.title");
            Object o = DialogManager.create((String)title, (JComponent)witnessChooser).setDialogId(WitnessChooser.class).setMessageType(3).setOptionType(2).show();
            if (o == DialogManager.CANCEL_OPTION) {
                return;
            }
            if (witnessChooser.isNew()) {
                this.m_witness = null;
                this.m_witnessToolTip = SELECT_WITNESS;
                this.invokeLiteners();
            } else {
                this.m_witness = witnessChooser.getWitness();
                this.m_witnessToolTip = CHANGE_WITNESS;
                this.invokeLiteners();
            }
        }

        void invokeLiteners() {
            for (WitnessUpdateListener listener : this.witnessUpdateListeners) {
                listener.witnessUpdated(this.m_text, this.m_witness);
            }
        }

        void addWitnessListener(WitnessUpdateListener listener) {
            this.witnessUpdateListeners.add(listener);
        }
    }

    static class SourceMediaSelection
    extends MergeTableAction {
        protected PropertyMedia m_selectedMedia;
        protected final List<PropertyMedia> m_existingSourceMedias;

        SourceMediaSelection(PropertyMedia selectedMedia, List<PropertyMedia> existingSourceMedias) {
            this.m_selectedMedia = selectedMedia;
            this.m_existingSourceMedias = existingSourceMedias;
        }

        PropertyMedia getProperty() {
            return this.m_selectedMedia;
        }

        @Override
        String getText() {
            return "";
        }

        String getToolTipText() {
            if (this.m_existingSourceMedias.isEmpty()) {
                return "";
            }
            return sourceMediaSelectionToolTip;
        }
    }

    static class SourceTextSelection
    extends MergeTableAction {
        protected PropertyMultilineValue m_selectedProperty;
        protected final List<PropertyMultilineValue> m_existingSourceText;

        SourceTextSelection(PropertyMultilineValue selectedProperty, List<PropertyMultilineValue> existingSourceText) {
            this.m_selectedProperty = selectedProperty;
            this.m_existingSourceText = existingSourceText;
        }

        PropertyMultilineValue getProperty() {
            return this.m_selectedProperty;
        }

        @Override
        String getText() {
            return "";
        }

        String getToolTipText() {
            if (this.m_existingSourceText.isEmpty()) {
                return "";
            }
            return sourceTextSelectionToolTip;
        }
    }

    static class SourceReliabilitySelection
    extends MergeTableAction {
        protected PropertyQuality m_property;
        protected String m_text;

        SourceReliabilitySelection(PropertyQuality property) {
            this.m_property = property;
        }

        PropertyQuality getProperty() {
            return this.m_property;
        }

        @Override
        String getText() {
            return this.m_text;
        }

        String getToolTipText() {
            return sourceReliabilitySelectionToolTip;
        }
    }

    static class SourceCitationSelection
    extends MergeTableAction {
        protected PropertySource m_selectedProperty;
        protected final List<PropertySource> m_existingSourceCitations;
        protected String m_text;

        SourceCitationSelection(PropertySource selectedProperty, List<PropertySource> existingSourceCitations) {
            this.m_selectedProperty = selectedProperty;
            this.m_existingSourceCitations = existingSourceCitations;
        }

        PropertySource getProperty() {
            return this.m_selectedProperty;
        }

        @Override
        String getText() {
            return this.m_text;
        }

        String getToolTipText() {
            if (this.m_existingSourceCitations.isEmpty()) {
                return sourceCitationSelectionEmptyToolTip;
            }
            return sourceCitationSelectionToolTip;
        }
    }

    static interface SourceUpdateListener {
        public void sourceUpdated(String var1, Source var2);
    }

    static class SourceRecordSelection
    extends MergeTableAction {
        private static final String CHANGE_SOURCE = NbBundle.getMessage(MergeTableAction.class, (String)"MergeTable.changeSource.ToolTip");
        private static final String SELECT_SOURCE = NbBundle.getMessage(MergeTableAction.class, (String)"MergeTable.selectSource.ToolTip");
        protected Source m_source;
        protected String m_text;
        private String m_sourceToolTip;
        private final ProposalHelper m_proposalHelper;
        private final Gedcom m_gedcom;
        protected final ArrayList<SourceUpdateListener> sourceUpdateListeners = new ArrayList();

        SourceRecordSelection(ProposalHelper proposalHelper, Source source, Gedcom gedcom) {
            this.m_proposalHelper = proposalHelper;
            this.m_gedcom = gedcom;
            this.m_source = source;
            this.m_text = "";
            if (proposalHelper.getEventSourceTitle().isEmpty()) {
                this.m_text = SELECT_SOURCE;
            } else if (source == null) {
                this.m_text = this.m_proposalHelper.getEventSourceTitle();
                this.m_sourceToolTip = CHANGE_SOURCE;
            } else {
                this.m_text = source.getDisplayTitle(false);
                this.m_sourceToolTip = CHANGE_SOURCE;
            }
        }

        @Override
        String getText() {
            return this.m_text;
        }

        String getToolTipText() {
            return this.m_sourceToolTip;
        }

        void setSource(Source source) {
            this.m_source = source;
            this.m_text = this.m_source != null ? this.m_source.getDisplayTitle(false) : this.m_proposalHelper.getEventSourceTitle();
        }

        void editAction(Frame parent) {
            SourceChooser sourceChooser = new SourceChooser(this.m_proposalHelper.getEventSourceTitle(), this.m_source, this.m_gedcom);
            String title = NbBundle.getMessage(this.getClass(), (String)"SourceChooser.title");
            Object o = DialogManager.create((String)title, (JComponent)sourceChooser).setDialogId(SourceChooser.class).setMessageType(3).setOptionType(2).show();
            if (o == DialogManager.CANCEL_OPTION) {
                return;
            }
            if (sourceChooser.isNew()) {
                this.m_source = null;
                this.m_text = sourceChooser.getNewSourceTitle();
                this.m_sourceToolTip = CHANGE_SOURCE;
                this.invokeLiteners();
            } else {
                this.m_source = sourceChooser.getSource();
                this.m_text = this.m_source != null ? sourceChooser.getSource().getDisplayTitle(false) : this.m_proposalHelper.getEventSourceTitle();
                this.m_sourceToolTip = CHANGE_SOURCE;
                this.invokeLiteners();
            }
        }

        void invokeLiteners() {
            for (SourceUpdateListener listener : this.sourceUpdateListeners) {
                listener.sourceUpdated(this.m_text, this.m_source);
            }
        }

        void addSourceListener(SourceUpdateListener listener) {
            this.sourceUpdateListeners.add(listener);
        }
    }

    static class ShowEntityAction
    extends MergeTableAction {
        protected Entity m_entity;
        protected String m_text;

        ShowEntityAction(Entity entity, String alternateLabel) {
            this.m_entity = entity;
            this.m_text = entity != null ? entity.getId() : alternateLabel;
        }

        @Override
        String getText() {
            return this.m_text;
        }

        String getToolTipText() {
            if (this.m_entity instanceof Source) {
                return showSourceToolTip;
            }
            if (this.m_entity instanceof Entity) {
                return showEntityToolTip;
            }
            return showEntityNewToolTip;
        }

        void showAction(Frame parent, boolean showAsRoot) {
            if (showAsRoot) {
                SelectionManager.setRootEntity((Property)this.m_entity);
            } else {
                SelectionManager.showEntity((Property)this.m_entity);
            }
        }
    }
}

