/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.model;

import ancestris.modules.releve.merge.MergeOptionPanel;
import org.openide.util.NbPreferences;

public class PlaceFormatModel {
    static final String CITYNAME_JURIDICTION = "RegisterPlaceToJuridiction.cityName";
    static final String CITYCODE_JURIDICTION = "RegisterPlaceToJuridiction.cityCode";
    static final String COUNTY_JURIDICTION = "RegisterPlaceToJuridiction.county";
    static final String STATE_JURIDICTION = "RegisterPlaceToJuridiction.state";
    static final String COUNTRY_JURIDICTION = "RegisterPlaceToJuridiction.country";
    static final String JURIDICTION_NUMBER = "RegisterPlaceToJuridiction.juridictionNumber";
    private int cityNameJuridiction = -1;
    private int cityCodeJuridiction = -1;
    private int countyJuridiction = -1;
    private int stateJuridiction = -1;
    private int countryJuridiction = -1;
    private int juridictionNumber = 5;
    private static PlaceFormatModel defaultPlaceModel = null;
    private String gedcomName = null;

    public static void saveDefaultGedcomName(String gedcomName) {
        NbPreferences.forModule(PlaceFormatModel.class).put("defaultGedcomName", gedcomName);
        defaultPlaceModel = new PlaceFormatModel(PlaceFormatModel.loadDefaultGedcomName());
    }

    public static String loadDefaultGedcomName() {
        return NbPreferences.forModule(PlaceFormatModel.class).get("defaultGedcomName", "default");
    }

    public static PlaceFormatModel getCurrentModel() {
        if (defaultPlaceModel == null) {
            MergeOptionPanel.GedcomFormatModel gedcomFormatModel = new MergeOptionPanel.GedcomFormatModel();
            defaultPlaceModel = gedcomFormatModel.defaultGedcom > -1 ? gedcomFormatModel.getDefaultGedcomInfo().getPlaceFormatModel() : new PlaceFormatModel(PlaceFormatModel.loadDefaultGedcomName());
        }
        return defaultPlaceModel;
    }

    public PlaceFormatModel(String gedcomName) {
        this.gedcomName = gedcomName + ".";
        this.loadPreferences();
    }

    public int getCityNameJuridiction() {
        return this.cityNameJuridiction;
    }

    public int getCityCodeJuridiction() {
        return this.cityCodeJuridiction;
    }

    public int getCountyJuridiction() {
        return this.countyJuridiction;
    }

    public int getStateJuridiction() {
        return this.stateJuridiction;
    }

    public int getCountryJuridiction() {
        return this.countryJuridiction;
    }

    public int getJuridictionNumber() {
        return this.juridictionNumber;
    }

    public void loadPreferences() {
        this.cityNameJuridiction = Integer.parseInt(NbPreferences.forModule(PlaceFormatModel.class).get(this.gedcomName + CITYNAME_JURIDICTION, "-1"));
        this.cityCodeJuridiction = Integer.parseInt(NbPreferences.forModule(PlaceFormatModel.class).get(this.gedcomName + CITYCODE_JURIDICTION, "-1"));
        this.countyJuridiction = Integer.parseInt(NbPreferences.forModule(PlaceFormatModel.class).get(this.gedcomName + COUNTY_JURIDICTION, "-1"));
        this.stateJuridiction = Integer.parseInt(NbPreferences.forModule(PlaceFormatModel.class).get(this.gedcomName + STATE_JURIDICTION, "-1"));
        this.countryJuridiction = Integer.parseInt(NbPreferences.forModule(PlaceFormatModel.class).get(this.gedcomName + COUNTRY_JURIDICTION, "-1"));
        this.juridictionNumber = Integer.parseInt(NbPreferences.forModule(PlaceFormatModel.class).get(this.gedcomName + JURIDICTION_NUMBER, "5"));
    }

    public void savePreferences(int cityName, int cityCode, int county, int state, int country, int juridictionNb) {
        this.cityNameJuridiction = cityName;
        this.cityCodeJuridiction = cityCode;
        this.countyJuridiction = county;
        this.stateJuridiction = state;
        this.countryJuridiction = country;
        this.juridictionNumber = juridictionNb;
        NbPreferences.forModule(PlaceFormatModel.class).put(this.gedcomName + CITYNAME_JURIDICTION, String.valueOf(this.cityNameJuridiction));
        NbPreferences.forModule(PlaceFormatModel.class).put(this.gedcomName + CITYCODE_JURIDICTION, String.valueOf(this.cityCodeJuridiction));
        NbPreferences.forModule(PlaceFormatModel.class).put(this.gedcomName + COUNTY_JURIDICTION, String.valueOf(this.countyJuridiction));
        NbPreferences.forModule(PlaceFormatModel.class).put(this.gedcomName + STATE_JURIDICTION, String.valueOf(this.stateJuridiction));
        NbPreferences.forModule(PlaceFormatModel.class).put(this.gedcomName + COUNTRY_JURIDICTION, String.valueOf(this.countryJuridiction));
        NbPreferences.forModule(PlaceFormatModel.class).put(this.gedcomName + JURIDICTION_NUMBER, String.valueOf(this.juridictionNumber));
    }

    public static enum RecordJuridiction {
        CITY_NAME,
        CITY_CODE,
        COUNTY,
        STATE,
        COUNTRY;

    }
}

