/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.table;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class ColumnGroup
extends TableColumn {
    protected TableCellRenderer renderer;
    protected ArrayList<TableColumn> v;
    protected String text;
    protected int margin = 0;

    public ColumnGroup(String text) {
        this(null, text);
    }

    public ColumnGroup(TableCellRenderer renderer, String text) {
        this.renderer = renderer == null ? new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JTableHeader header = table.getTableHeader();
                if (header != null) {
                    this.setForeground(header.getForeground());
                    this.setBackground(header.getBackground());
                    this.setFont(header.getFont());
                }
                this.setHorizontalAlignment(0);
                this.setText(value == null ? "" : value.toString());
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                return this;
            }
        } : renderer;
        this.text = text;
        this.v = new ArrayList();
    }

    public void add(TableColumn obj) {
        if (obj == null) {
            return;
        }
        this.v.add(obj);
    }

    public ArrayList<TableColumn> getColumnGroups(TableColumn c, ArrayList<TableColumn> g) {
        g.add(this);
        if (this.v.contains(c)) {
            return g;
        }
        for (TableColumn obj : this.v) {
            ArrayList<TableColumn> clone;
            ArrayList<TableColumn> groups;
            if (!(obj instanceof ColumnGroup) || (groups = ((ColumnGroup)obj).getColumnGroups(c, clone = new ArrayList<TableColumn>(g))) == null) continue;
            return groups;
        }
        return null;
    }

    @Override
    public TableCellRenderer getHeaderRenderer() {
        return this.renderer;
    }

    @Override
    public void setHeaderRenderer(TableCellRenderer renderer) {
        if (renderer != null) {
            this.renderer = renderer;
        }
    }

    @Override
    public Object getHeaderValue() {
        return this.text;
    }

    public Dimension getSize(JTable table) {
        Component comp = this.renderer.getTableCellRendererComponent(table, this.getHeaderValue(), false, false, -1, -1);
        int columnHeight = comp.getPreferredSize().height;
        int columnWidth = 0;
        for (TableColumn obj : this.v) {
            if (obj instanceof ColumnGroup) {
                columnWidth += ((ColumnGroup)obj).getSize((JTable)table).width;
                continue;
            }
            columnWidth += obj.getWidth();
        }
        return new Dimension(columnWidth, columnHeight);
    }

    public void setColumnMargin(int margin) {
        this.margin = margin;
        for (TableColumn obj : this.v) {
            if (!(obj instanceof ColumnGroup)) continue;
            ((ColumnGroup)obj).setColumnMargin(margin);
        }
    }
}

