/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcomcompare.tools;

import ancestris.modules.gedcomcompare.tools.STEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class STObject {
    public String spaceTime = "";
    public int nbB = 0;
    public int nbM = 0;
    public int nbS = 0;
    public int nbZ = 0;
    public Set<String> cities = new HashSet<String>();
    public Set<String> names = new HashSet<String>();
    public Set<String> years = new HashSet<String>();
    public int nbCities = 0;
    public int nbNames = 0;
    public int nbYears = 0;
    public List<STEvent> eventsCityNames1 = new ArrayList<STEvent>();
    public List<STEvent> eventsCityNames2 = new ArrayList<STEvent>();
    public int nbCityName = 0;
    public List<STEvent> events = new ArrayList<STEvent>();
    public int nbEvents = 0;
    public Double lat = 0.0;
    public Double lon = 0.0;

    public STObject() {
    }

    public STObject(String spaceTime, List<STEvent> events) {
        this.spaceTime = spaceTime;
        for (STEvent event : events) {
            switch (event.type) {
                case "B": {
                    ++this.nbB;
                    break;
                }
                case "M": {
                    ++this.nbM;
                    break;
                }
                case "S": {
                    ++this.nbS;
                    break;
                }
                case "Z": {
                    ++this.nbZ;
                }
            }
            this.cities.add(event.city);
            this.names.addAll(Arrays.asList(event.lastnames));
            this.years.add(String.valueOf(event.year));
            this.lat = this.lat + event.lat;
            this.lon = this.lon + event.lon;
        }
        this.nbCities = this.cities.size();
        this.nbNames = this.names.size();
        this.nbYears = this.years.size();
        this.events = events;
        this.nbEvents = events.size();
        if (this.nbEvents != 0) {
            this.lat = this.lat / (double)this.nbEvents;
            this.lon = this.lon / (double)this.nbEvents;
        }
    }

    public int getTime() {
        String[] bits = this.spaceTime.split("-");
        return Integer.parseInt(bits[1]);
    }

    public boolean isEligible(int level) {
        if (level == 1) {
            return true;
        }
        if (level == 2) {
            return this.nbCities > 0 && this.nbNames > 0;
        }
        if (level == 3) {
            return this.nbEvents > 0 || this.nbCityName > 0 || this.nbCities > 0 && this.nbNames > 0;
        }
        return false;
    }

    public String toString() {
        return this.spaceTime;
    }

    public void setNbEvents(int set) {
        this.nbEvents = set;
    }
}

