/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.graph.layout;

import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.api.visual.graph.GraphPinScene;
import org.netbeans.api.visual.graph.GraphScene;
import org.netbeans.api.visual.model.ObjectScene;

public abstract class UniversalGraph<N, E> {
    public abstract ObjectScene getScene();

    public abstract Collection<N> getNodes();

    public abstract Collection<E> getEdges();

    public abstract Collection<E> findNodeEdges(N var1, boolean var2, boolean var3);

    public abstract N getEdgeSource(E var1);

    public abstract N getEdgeTarget(E var1);

    static <N, E> UniversalGraph<N, E> createUniversalGraph(final GraphScene<N, E> scene) {
        return new UniversalGraph<N, E>(){

            @Override
            public ObjectScene getScene() {
                return scene;
            }

            @Override
            public Collection<N> getNodes() {
                return scene.getNodes();
            }

            @Override
            public Collection<E> getEdges() {
                return scene.getEdges();
            }

            @Override
            public Collection<E> findNodeEdges(N node, boolean allowsOutputEdges, boolean allowsInputEdges) {
                return scene.findNodeEdges(node, allowsOutputEdges, allowsInputEdges);
            }

            @Override
            public N getEdgeSource(E edge) {
                return scene.getEdgeSource(edge);
            }

            @Override
            public N getEdgeTarget(E edge) {
                return scene.getEdgeTarget(edge);
            }
        };
    }

    static <N, E, P> UniversalGraph<N, E> createUniversalGraph(final GraphPinScene<N, E, P> scene) {
        return new UniversalGraph<N, E>(){

            @Override
            public ObjectScene getScene() {
                return scene;
            }

            @Override
            public Collection<N> getNodes() {
                return scene.getNodes();
            }

            @Override
            public Collection<E> getEdges() {
                return scene.getEdges();
            }

            @Override
            public Collection<E> findNodeEdges(N node, boolean allowsOutputEdges, boolean allowsInputEdges) {
                ArrayList list = new ArrayList();
                for (Object pin : scene.getNodePins(node)) {
                    list.addAll(scene.findPinEdges(pin, allowsOutputEdges, allowsInputEdges));
                }
                return list;
            }

            @Override
            public N getEdgeSource(E edge) {
                return scene.getPinNode(scene.getEdgeSource(edge));
            }

            @Override
            public N getEdgeTarget(E edge) {
                return scene.getPinNode(scene.getEdgeTarget(edge));
            }
        };
    }
}

