/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.action;

import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public final class PopupMenuAction
extends WidgetAction.Adapter {
    private PopupMenuProvider provider;

    public PopupMenuAction(PopupMenuProvider provider) {
        this.provider = provider;
    }

    @Override
    public WidgetAction.State mousePressed(Widget widget, WidgetAction.WidgetMouseEvent event) {
        return this.handleMouseEvent(widget, event);
    }

    @Override
    public WidgetAction.State mouseReleased(Widget widget, WidgetAction.WidgetMouseEvent event) {
        return this.handleMouseEvent(widget, event);
    }

    protected WidgetAction.State handleMouseEvent(Widget widget, WidgetAction.WidgetMouseEvent event) {
        if (event.isPopupTrigger()) {
            JPopupMenu popupMenu = this.provider.getPopupMenu(widget, event.getPoint());
            if (popupMenu != null) {
                Scene scene = widget.getScene();
                Point point = scene.convertSceneToView(widget.convertLocalToScene(event.getPoint()));
                popupMenu.show(scene.getView(), point.x, point.y);
            }
            return WidgetAction.State.CONSUMED;
        }
        return WidgetAction.State.REJECTED;
    }

    @Override
    public WidgetAction.State keyPressed(Widget widget, WidgetAction.WidgetKeyEvent event) {
        if (event.getKeyCode() == 525 || (event.getModifiers() & 1) == 1 && event.getKeyCode() == 121) {
            JComponent view;
            JPopupMenu popupMenu = this.provider.getPopupMenu(widget, null);
            if (popupMenu != null && (view = widget.getScene().getView()) != null) {
                Rectangle bounds = widget.getBounds();
                Point location = new Point(bounds.x + 5, bounds.y + 5);
                location = widget.convertLocalToScene(location);
                location = widget.getScene().convertSceneToView(location);
                popupMenu.show(view, location.x, location.y);
            }
            return WidgetAction.State.CONSUMED;
        }
        return WidgetAction.State.REJECTED;
    }
}

