/*
 * Decompiled with CFR 0.152.
 */
package ancestris.app;

import ancestris.core.CoreOptions;
import ancestris.gedcom.GedcomDirectory;
import java.net.URL;
import javax.swing.JMenuItem;
import org.netbeans.api.actions.Openable;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CookieAction;

public final class ActionOpenDefault
extends CookieAction
implements Openable {
    private static String NOFILE = NbBundle.getMessage(ActionOpenDefault.class, (String)"ActionOpenDefault.NoFile");
    private FileObject fileToOpen = null;

    protected int mode() {
        return 7;
    }

    protected Class<?>[] cookieClasses() {
        return new Class[]{String.class};
    }

    protected void performAction(Node[] nodes) {
        this.open();
    }

    protected boolean asynchronous() {
        return false;
    }

    public String getName() {
        String name = this.getDefaultFile();
        boolean nameDefined = name != null && !name.isEmpty();
        this.setEnabled(nameDefined);
        String str = nameDefined ? name : NOFILE;
        return NbBundle.getMessage(ActionOpenDefault.class, (String)"CTL_ActionOpenDefault") + " " + str;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean enable(Node[] arg0) {
        super.enable(arg0);
        return this.fileToOpen != null;
    }

    protected String iconResource() {
        return "ancestris/view/images/OpenDefault.png";
    }

    public JMenuItem getMenuPresenter() {
        JMenuItem item = super.getMenuPresenter();
        return item;
    }

    private String getDefaultFile() {
        URL defaultFile = this.getPrefsFile();
        if (defaultFile == null) {
            return null;
        }
        this.fileToOpen = this.getValidFile(defaultFile);
        return this.fileToOpen == null ? null : this.fileToOpen.getNameExt();
    }

    private URL getPrefsFile() {
        return CoreOptions.getInstance().getDefaultGedcom();
    }

    public FileObject getValidFile(URL file) {
        FileObject fo;
        try {
            fo = URLMapper.findFileObject((URL)file);
            if (!fo.isValid() || fo.isFolder()) {
                return null;
            }
        }
        catch (Throwable t) {
            return null;
        }
        return fo;
    }

    public void open() {
        if (this.fileToOpen != null) {
            try {
                GedcomDirectory.getDefault().openGedcom(this.fileToOpen);
            }
            catch (Exception e) {
                System.out.println("Error opening default gedcom:" + e);
            }
        }
    }
}

