/*
 * Decompiled with CFR 0.152.
 */
package ancestris.util;

import ancestris.app.App;
import ancestris.util.StartAndStopPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.ResourceBundle;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.LifecycleManager;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class Lifecycle {
    public static void askForRestart(String message) {
        ResourceBundle bundle = NbBundle.getBundle(App.class);
        String msg = message == null ? bundle.getString("NeedRestart.text") : message;
        DialogDescriptor dd = new DialogDescriptor((Object)msg, bundle.getString("NeedRestart.title"), false, 0, null, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (arg0.getSource() == NotifyDescriptor.YES_OPTION) {
                    LifecycleManager.getDefault().markForRestart();
                    LifecycleManager.getDefault().exit();
                }
            }
        });
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)dd);
    }

    public static void askForRestart() {
        Lifecycle.askForRestart(null);
    }

    public static void askForStopAndStart(String message, Locale locale, boolean darkModeChanged) {
        ResourceBundle bundle = locale == null ? NbBundle.getBundle(App.class) : NbBundle.getBundle((String)Lifecycle.findName(App.class), (Locale)locale, (ClassLoader)App.class.getClassLoader());
        String title = bundle.getString("NeedStopStart.title");
        String msg = message == null ? bundle.getString("NeedStopStart.text") : message;
        final StartAndStopPanel panel = new StartAndStopPanel(msg, darkModeChanged, bundle);
        DialogDescriptor dd = new DialogDescriptor((Object)panel, title, false, 0, null, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (arg0.getSource() == NotifyDescriptor.YES_OPTION) {
                    panel.processDarkModeChange();
                    LifecycleManager.getDefault().exit();
                }
            }
        });
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)dd);
    }

    public static void askForStopAndStart() {
        Lifecycle.askForStopAndStart(null, null, false);
    }

    private static String findName(Class<?> clazz) {
        String pref = clazz.getName();
        int last = pref.lastIndexOf(46);
        if (last >= 0) {
            pref = pref.substring(0, last + 1);
            return pref + "Bundle";
        }
        return "Bundle";
    }
}

