/*
 * Decompiled with CFR 0.152.
 */
package ancestris.view;

import ancestris.gedcom.GedcomFileListener;
import ancestris.swing.ToolBar;
import ancestris.view.AncestrisTopComponent;
import genj.gedcom.Context;
import genj.gedcom.Gedcom;
import genj.view.View;
import genj.view.ViewFactory;
import java.awt.Image;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public abstract class GenjViewTopComponent
extends AncestrisTopComponent
implements GedcomFileListener {
    private static final Logger LOG = Logger.getLogger("ancestris.view");
    private View view;

    public abstract ViewFactory getViewFactory();

    @Override
    public Image getImageIcon() {
        if (this.getViewFactory() != null) {
            return this.getViewFactory().getImage().getImage();
        }
        return super.getImageIcon();
    }

    @Override
    public String getIconBase() {
        if (this.getViewFactory() != null) {
            return this.getViewFactory().getIconBase();
        }
        return super.getIconBase();
    }

    @Override
    public void setName() {
        if (this.getViewFactory() != null) {
            this.setName(this.getViewFactory().getTitle());
        }
        super.setName();
    }

    @Override
    public void setToolTipText() {
        if (this.getViewFactory() != null) {
            this.setToolTipText(this.getViewFactory().getTooltip());
        } else {
            super.setToolTipText();
        }
    }

    protected void componentOpened() {
        super.componentOpened();
        if (this.getViewFactory() != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (GenjViewTopComponent.this.view != null) {
                        GenjViewTopComponent.this.view.setContext(GenjViewTopComponent.this.getContext());
                    }
                }
            });
        }
    }

    @Override
    public JToolBar getToolBar() {
        if (this.view == null) {
            return null;
        }
        ToolBar bar = new ToolBar();
        bar.beginUpdate();
        this.view.populate(bar);
        bar.endUpdate();
        return bar.getToolBar();
    }

    @Override
    public boolean createPanel() {
        if (this.view == null && this.getViewFactory() != null) {
            this.view = this.getViewFactory().createView();
        }
        if (this.view == null) {
            return false;
        }
        this.setPanel((JComponent)this.view);
        this.setContext(this.getContext());
        this.addToolBar();
        return true;
    }

    @Override
    public void componentClosed() {
        if (this.view != null) {
            this.view.closing();
        }
        this.view = null;
        super.componentClosed();
    }

    @Override
    public boolean canClose() {
        return super.canClose();
    }

    @Override
    protected void setContextImpl(Context context) {
        if (this.view != null) {
            this.view.setContext(context);
        } else {
            super.setContextImpl(context);
        }
    }

    public View getView() {
        return this.view;
    }

    public void commitRequested(Context context) {
        if (!context.sameGedcom(this.getContext())) {
            LOG.log(Level.FINER, "context selection on unknown gedcom", new Throwable());
            return;
        }
        if (this.view != null) {
            this.view.commit();
        }
    }

    public void gedcomClosed(Gedcom gedcom) {
    }

    public void gedcomOpened(Gedcom gedcom) {
    }
}

