/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.matchers;

import ancestris.modules.gedcom.matchers.MatcherOptions;
import ancestris.modules.gedcom.matchers.Options;
import ancestris.modules.gedcom.searchdupes.DuplicatesResults;
import ancestris.modules.gedcom.searchdupes.DuplicatesTask;
import ancestris.modules.gedcom.searchdupes.Log;
import ancestris.modules.gedcom.searchdupes.NonDuplicates;
import ancestris.modules.gedcom.searchdupes.SearchDuplicatesAction;
import ancestris.util.GedcomUtilities;
import ancestris.util.ProgressListener;
import ancestris.util.Utilities;
import ancestris.util.swing.PotentialMatch;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyPlace;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.PointInTime;
import genj.util.Trackable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.openide.util.NbBundle;
import spin.Spin;

public abstract class EntityMatcher<E extends Entity, O extends MatcherOptions>
implements Comparator<E>,
Options<O> {
    private static final int BATCH_SIZE = 10000;
    protected static final int MIN_THRESHOLD = 40;
    private Gedcom gedcom;
    protected O options = null;
    private List<E> entities;
    private boolean excludedNonDup;
    private final Set<String> dupKeys = new HashSet<String>();
    private Set<String> nonDupKeys = null;
    private String tag;
    private int step;
    private int stepMax;
    private LinkedHashMap<String, List<E>> key2entities;
    private List<PotentialMatch<E>> entityDuplicates = new ArrayList<PotentialMatch<E>>();
    protected static int COMPARE_SURE_SAME = 4;
    protected static int COMPARE_RATHER_SAME = 3;
    protected static int COMPARE_UNKNOWN = 2;
    protected static int COMPARE_RATHER_DIFFERENT = 1;
    protected static int COMPARE_SURE_DIFFERENT = 0;

    public abstract String[] getKeys(E var1);

    public abstract String getHexaKey(E var1);

    public abstract void reset();

    public void setInputs(List<E> entities, boolean excludedNonDup, int step, int stepMax) {
        this.entities = entities;
        this.excludedNonDup = excludedNonDup;
        this.gedcom = ((Entity)entities.get(0)).getGedcom();
        this.tag = ((Entity)entities.get(0)).getTag();
        this.step = step;
        this.stepMax = stepMax;
    }

    @Override
    public void setOptions(O options) {
        this.options = options;
    }

    @Override
    public O getOptions() {
        return this.options;
    }

    public void run() {
        CalculateEntityKeysTask keysTask = new CalculateEntityKeysTask(this.entities);
        DuplicatesTask task1 = (DuplicatesTask)Spin.off((Object)keysTask);
        task1.run();
        CalculateEntityDuplicatesTask calcTask = new CalculateEntityDuplicatesTask(40, 10000, false);
        DuplicatesTask task2 = (DuplicatesTask)Spin.off((Object)calcTask);
        task2.run();
    }

    public List<PotentialMatch<? extends Entity>> getResult() {
        return new ArrayList<PotentialMatch<? extends Entity>>(this.entityDuplicates);
    }

    public CalculateEntityKeysTask getcalculateEntityKeys() {
        return new CalculateEntityKeysTask(this.entities);
    }

    public List<PotentialMatch<E>> getDuplicates(E leftEntity, List<E> entityList, boolean excludedNonDup, int threshold) {
        this.nonDupKeys = NonDuplicates.getNonDupKeys(leftEntity.getGedcom());
        ArrayList<PotentialMatch<E>> matches = new ArrayList<PotentialMatch<E>>();
        this.getDuplicatesOfEntity(entityList.indexOf(leftEntity), leftEntity, entityList, matches, excludedNonDup, threshold, false, null, null);
        return matches;
    }

    public CalculateEntityDuplicatesTask getcalculationTask(int thresholdValue) {
        return new CalculateEntityDuplicatesTask(thresholdValue, 10000, true);
    }

    private int getDuplicatesOfEntity(int indexL, E leftEntity, List<E> entityList, List<PotentialMatch<E>> matches, boolean excludedNonDup, int minThreshold, boolean mergeMode, Log log, DuplicatesResults tool) {
        int ret = 0;
        for (int indexR = indexL + 1; indexR < entityList.size(); ++indexR) {
            int diff;
            String idKey;
            Entity rightEntity = (Entity)entityList.get(indexR);
            if (rightEntity.getGedcom() == null || leftEntity.getGedcom() == null || excludedNonDup && this.nonDupKeys.contains(idKey = this.getIdKey(leftEntity.getId(), rightEntity.getId())) || (diff = this.compare(leftEntity, rightEntity)) < minThreshold) continue;
            PotentialMatch match = new PotentialMatch(leftEntity, (Object)rightEntity, diff);
            if (mergeMode) {
                if (tool.mergeMatch(log, (PotentialMatch<? extends Entity>)match)) {
                    ++ret;
                    continue;
                }
                matches.add(match);
                continue;
            }
            String matchKey = this.getIdKey(((Entity)match.getLeft()).getId(), ((Entity)match.getRight()).getId());
            if (this.dupKeys.contains(matchKey)) continue;
            matches.add(match);
            this.dupKeys.add(matchKey);
            ++ret;
        }
        return ret;
    }

    protected String getIdKey(String id1, String id2) {
        return id1.compareTo(id2) < 0 ? id1 + "+" + id2 : id2 + "+" + id1;
    }

    protected static List<String> getKeyWords(String str, int size) {
        return EntityMatcher.getKeyWords(EntityMatcher.getWordsMap(str), size);
    }

    protected static List<String> getKeyWords(Map<String, Integer> map, int size) {
        ArrayList<String> ret = new ArrayList<String>();
        LinkedHashMap sortedMap = map.entrySet().stream().sorted((o1, o2) -> ((Integer)o2.getValue()).compareTo((Integer)o1.getValue()) == 0 ? Integer.compare(((String)o2.getKey()).length(), ((String)o1.getKey()).length()) : ((Integer)o2.getValue()).compareTo((Integer)o1.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
        int ctr = 0;
        for (String word : sortedMap.keySet()) {
            if (ctr >= size) break;
            ret.add(word);
            ++ctr;
        }
        return ret;
    }

    protected static Map<String, Integer> getWordsMap(String str) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        String ns = EntityMatcher.normalizePhraseString(str);
        if (ns.isEmpty()) {
            return map;
        }
        if (ns.indexOf(" ") == -1) {
            map.put(ns, 1);
            return map;
        }
        List<String> words = EntityMatcher.splitWords(ns);
        if (words.isEmpty()) {
            map.put(ns.replaceAll(" ", ""), 1);
            return map;
        }
        words.forEach(word -> {
            int factor = 1;
            if (Character.toUpperCase(word.charAt(0)) == word.charAt(0)) {
                factor = 5;
            }
            map.put((String)word, map.getOrDefault(word, 0) + factor);
        });
        return map;
    }

    private static List<String> splitWords(String str) {
        List<String> words = Arrays.asList(str.split("\\s+"));
        ArrayList<String> ret = new ArrayList<String>();
        for (String word : words) {
            if (words.size() >= 15 && word.length() <= 3 && !word.matches(".*\\d.*")) continue;
            ret.add(word);
        }
        return ret;
    }

    private static String normalizePhraseString(String str) {
        String normalized = str.replaceAll("<[^>]*>", "");
        normalized = Utilities.removeDiacritics((String)normalized);
        normalized = EntityMatcher.lowercase(normalized, "(\\. +.|\\- +.|^.)");
        normalized = EntityMatcher.lowercase(normalized, "(?<=^|[^A-Za-z])([A-Z])(?=[^A-Za-z]|$)");
        normalized = normalized.replaceAll("[,\\.]", " ");
        normalized = normalized.replaceAll("[^A-Za-z0-9 ]", "").replaceAll(" +", " ").trim();
        return normalized;
    }

    private static String lowercase(String src, String pattern) {
        Matcher m = Pattern.compile(pattern).matcher(src);
        StringBuilder sb = new StringBuilder();
        int last = 0;
        while (m.find()) {
            sb.append(src.substring(last, m.start()));
            sb.append(m.group(0).toLowerCase());
            last = m.end();
        }
        sb.append(src.substring(last));
        return sb.toString();
    }

    protected int getLevel(int score) {
        if (score >= 100) {
            return COMPARE_SURE_SAME;
        }
        if (score >= 60) {
            return COMPARE_RATHER_SAME;
        }
        if (score >= 20) {
            return COMPARE_RATHER_DIFFERENT;
        }
        return COMPARE_SURE_DIFFERENT;
    }

    /*
     * WARNING - void declaration
     */
    protected static int compareNames(NameData name1, NameData name2) {
        void var6_12;
        if (name1.fullname.equals(name2.fullname)) {
            return COMPARE_SURE_SAME;
        }
        int n = Math.min(name1.lastNames.size(), name2.lastNames.size());
        if (n == 0) {
            return COMPARE_UNKNOWN;
        }
        int identical = 0;
        int similar = 0;
        block0: for (String string : name1.lastNames) {
            for (String lastname2 : name2.lastNames) {
                if (string.equals(lastname2)) {
                    ++identical;
                    continue block0;
                }
                if (!GedcomUtilities.isSimilar((String)string, (String)lastname2)) continue;
                ++similar;
                continue block0;
            }
        }
        int lastnameScore = 0;
        if (identical >= n) {
            lastnameScore = COMPARE_SURE_SAME;
        } else if (identical >= Math.max(1, n / 2) || similar >= Math.max(1, n / 2)) {
            lastnameScore = COMPARE_RATHER_SAME;
        } else {
            if (identical == 0 && similar == 0) {
                return COMPARE_SURE_DIFFERENT;
            }
            return COMPARE_RATHER_DIFFERENT;
        }
        n = Math.min(name1.firstNames.size(), name2.firstNames.size());
        if (n == 0) {
            return COMPARE_UNKNOWN;
        }
        identical = 0;
        similar = 0;
        block2: for (String firstname1 : name1.firstNames) {
            for (String firstname2 : name2.firstNames) {
                if (firstname1.equals(firstname2)) {
                    ++identical;
                    continue block2;
                }
                if (!GedcomUtilities.isSimilar((String)firstname1, (String)firstname2)) continue;
                ++similar;
                continue block2;
            }
        }
        boolean bl = false;
        if (identical >= n) {
            int n2 = COMPARE_SURE_SAME;
        } else if (identical >= Math.max(1, n / 2) || similar >= Math.max(1, n / 2)) {
            int n3 = COMPARE_RATHER_SAME;
        } else {
            if (identical == 0 && similar == 0) {
                return COMPARE_SURE_DIFFERENT;
            }
            return COMPARE_RATHER_DIFFERENT;
        }
        if (lastnameScore == COMPARE_SURE_SAME) {
            return (int)var6_12;
        }
        if (var6_12 >= COMPARE_RATHER_SAME) {
            return COMPARE_RATHER_SAME;
        }
        return (int)var6_12;
    }

    protected static int compareDates(DateData date1, DateData date2) {
        if (date1.dateDisplayValue.equals(date2.dateDisplayValue)) {
            return COMPARE_SURE_SAME;
        }
        if (!date1.dateIsRange && !date2.dateIsRange && date1.dateIsComplete && date2.dateIsComplete && Math.abs(date1.dateStartJD - date2.dateStartJD) > 1) {
            return COMPARE_SURE_DIFFERENT;
        }
        if (!date1.dateIsRange && !date2.dateIsRange && (date1.dateIsYearOnly || date2.dateIsYearOnly)) {
            return date1.dateYear == date2.dateYear ? COMPARE_SURE_SAME : COMPARE_SURE_DIFFERENT;
        }
        int gap = 0;
        int overlap = 0;
        int diff1 = date2.dateStartJD - date1.dateEndJD - 1;
        int diff2 = date2.dateEndJD - date1.dateStartJD + 1;
        int diff = Math.min(Math.abs(diff1), Math.abs(diff2));
        if (diff1 >= 0 && diff2 >= 0 || diff1 <= 0 && diff2 <= 0) {
            gap = diff;
        } else {
            overlap = diff;
        }
        if (overlap > 0) {
            return COMPARE_RATHER_SAME;
        }
        if (gap < 120) {
            return COMPARE_RATHER_SAME;
        }
        if (gap < 366) {
            return COMPARE_RATHER_DIFFERENT;
        }
        return COMPARE_SURE_DIFFERENT;
    }

    protected static int comparePlaces(PlaceData place1, PlaceData place2) {
        if (place1.placeDisplayValue.equals(place2.placeDisplayValue)) {
            return COMPARE_SURE_SAME;
        }
        boolean similarPlace = GedcomUtilities.isSimilar((String)place1.placeDisplayValue, (String)place2.placeDisplayValue);
        if (similarPlace) {
            return COMPARE_RATHER_SAME;
        }
        boolean identicalCtry = place1.country.equals(place2.country);
        boolean identicalCity = place1.city.equals(place2.city);
        boolean similarCtry = GedcomUtilities.isSimilar((String)place1.country, (String)place2.country);
        boolean similarCity = GedcomUtilities.isSimilar((String)place1.city, (String)place2.city);
        if (!(identicalCity || similarCity || identicalCtry || similarCtry)) {
            return COMPARE_SURE_DIFFERENT;
        }
        if (identicalCity && identicalCtry) {
            return COMPARE_SURE_SAME;
        }
        if (similarCity && identicalCtry) {
            return COMPARE_RATHER_SAME;
        }
        if (identicalCity && similarCtry) {
            return COMPARE_RATHER_SAME;
        }
        return COMPARE_RATHER_DIFFERENT;
    }

    public class CalculateEntityKeysTask
    implements DuplicatesTask {
        private final List<E> entities;
        private int keysProgress = 0;
        private int keysProgressMax = 0;
        private String keysState = "";
        private String keysTaskname = "";
        private boolean keysCancel = false;

        public CalculateEntityKeysTask(List<E> entities) {
            this.entities = entities;
        }

        @Override
        public void run() {
            ProgressListener.Dispatcher.processStarted((Trackable)this);
            EntityMatcher.this.key2entities = this.calculateEntityKeys(this.entities);
            ProgressListener.Dispatcher.processStopped((Trackable)this);
        }

        public void cancelTrackable() {
            this.keysCancel = true;
        }

        public int getProgress() {
            if (this.keysProgressMax == 0) {
                return 0;
            }
            return 100 * this.keysProgress / this.keysProgressMax;
        }

        public String getState() {
            return this.keysState;
        }

        public String getTaskName() {
            return this.keysTaskname;
        }

        public LinkedHashMap<String, List<E>> calculateEntityKeys(List<E> entities) {
            this.keysProgress = 0;
            this.keysProgressMax = entities.size();
            this.keysTaskname = NbBundle.getMessage(SearchDuplicatesAction.class, (String)"EntityMatcher.CalculateEntityKeysTask.taskname", (Object)Gedcom.getName((String)EntityMatcher.this.tag), (Object)EntityMatcher.this.step, (Object)EntityMatcher.this.stepMax);
            LinkedHashMap grossMap = new LinkedHashMap();
            if (entities.isEmpty()) {
                return grossMap;
            }
            for (Entity entity : entities) {
                if (this.keysCancel) {
                    return grossMap;
                }
                ++this.keysProgress;
                this.keysState = NbBundle.getMessage(SearchDuplicatesAction.class, (String)"EntityMatcher.CalculateEntityKeysTask.state", (Object)Gedcom.getName((String)EntityMatcher.this.tag), (Object)this.keysProgress, (Object)this.keysProgressMax, (Object)grossMap.size(), (Object[])new Object[0]);
                for (String key : EntityMatcher.this.getKeys(entity)) {
                    List<Object> list = grossMap.get(key);
                    if (list == null) {
                        list = new ArrayList();
                        grossMap.put(key, list);
                    } else if (list.size() >= 30) {
                        boolean limitReached = true;
                        int nb = 1;
                        while (limitReached) {
                            String hexaKey = EntityMatcher.this.getHexaKey(entity);
                            String longKey = key + "-" + hexaKey + "-" + String.format("%03d", nb);
                            list = grossMap.get(longKey);
                            if (list == null) {
                                list = new ArrayList();
                                grossMap.put(longKey, list);
                            } else if (list.size() >= 30) {
                                ++nb;
                                continue;
                            }
                            limitReached = false;
                        }
                    }
                    list.add(entity);
                }
            }
            Comparator bySize = (o1, o2) -> {
                int i2;
                int i1 = o1.size();
                if (i1 > (i2 = o2.size())) {
                    return -1;
                }
                if (i1 < i2) {
                    return 1;
                }
                return 0;
            };
            Comparator byKey = (o1, o2) -> o1.compareTo((String)o2);
            LinkedHashMap sortedMap = grossMap.entrySet().stream().filter(map -> ((List)map.getValue()).size() > 1).sorted(Map.Entry.comparingByValue(bySize).thenComparing(Map.Entry.comparingByKey(byKey))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
            return sortedMap;
        }

        @Override
        public List<PotentialMatch<? extends Entity>> getResult() {
            return null;
        }

        public LinkedHashMap<String, List<E>> getClusters() {
            return EntityMatcher.this.key2entities;
        }
    }

    public class CalculateEntityDuplicatesTask
    implements DuplicatesTask {
        private int dupProgress = 0;
        private int dupProgressMax = 0;
        private String dupState = "";
        private String dupTaskname = "";
        private boolean cancel = false;
        private boolean error = false;
        private int minThreshold = 0;
        private int batchsize = 10000;
        private boolean mergeMode = false;
        private int mergedNb = 0;
        private int startingKey = 0;
        private Log log;
        private DuplicatesResults tool;

        public CalculateEntityDuplicatesTask(int minThreshold, int batchsize, boolean mergeMode) {
            this.minThreshold = minThreshold;
            this.mergeMode = mergeMode;
            this.batchsize = batchsize;
        }

        @Override
        public void run() {
            ProgressListener.Dispatcher.processStarted((Trackable)this);
            EntityMatcher.this.entityDuplicates = this.calculateEntityDuplicates();
            ProgressListener.Dispatcher.processStopped((Trackable)this);
        }

        public void cancelTrackable() {
            this.cancel = true;
        }

        public int getProgress() {
            if (this.dupProgressMax == 0) {
                return 0;
            }
            return 100 * this.dupProgress / this.dupProgressMax;
        }

        public String getState() {
            return this.dupState;
        }

        public String getTaskName() {
            return this.dupTaskname;
        }

        private List<PotentialMatch<E>> calculateEntityDuplicates() {
            Object bundleTask = "EntityMatcher.CalculateEntityDuplicatesTask.taskname";
            Object bundleState = "EntityMatcher.CalculateEntityDuplicatesTask.state";
            if (this.mergeMode) {
                bundleTask = (String)bundleTask + "Merge";
                bundleState = (String)bundleState + "Merge";
            }
            EntityMatcher.this.dupKeys.clear();
            EntityMatcher.this.nonDupKeys = NonDuplicates.getNonDupKeys(EntityMatcher.this.gedcom);
            this.dupProgress = 0;
            this.mergedNb = 0;
            this.dupProgressMax = EntityMatcher.this.key2entities.keySet().size();
            this.dupTaskname = NbBundle.getMessage(SearchDuplicatesAction.class, (String)bundleTask, (Object)this.minThreshold, (Object)Gedcom.getName((String)EntityMatcher.this.tag));
            ArrayList tmpEntityDuplicates = new ArrayList();
            EntityMatcher.this.reset();
            Object[] keysArray = EntityMatcher.this.key2entities.keySet().toArray();
            for (int indexKey = this.startingKey; indexKey < keysArray.length; ++indexKey) {
                ++this.dupProgress;
                String key = (String)keysArray[indexKey];
                if (this.cancel) {
                    if (this.log != null) {
                        this.log.error(NbBundle.getMessage(SearchDuplicatesAction.class, (String)"MassMergeEntitiesTask.abortRequeted"));
                    }
                    return this.sortAndCutList(tmpEntityDuplicates, this.batchsize);
                }
                List entityList = EntityMatcher.this.key2entities.get(key);
                int sizeKeys = entityList.size();
                for (int indexL = 0; indexL < sizeKeys - 1; ++indexL) {
                    Entity leftEntity = (Entity)entityList.get(indexL);
                    if (leftEntity.getGedcom() == null) continue;
                    this.mergedNb += EntityMatcher.this.getDuplicatesOfEntity(indexL, leftEntity, entityList, tmpEntityDuplicates, EntityMatcher.this.excludedNonDup, this.minThreshold, this.mergeMode, this.log, this.tool);
                    this.dupState = NbBundle.getMessage(SearchDuplicatesAction.class, (String)bundleState, (Object)this.dupProgress, (Object)this.dupProgressMax, (Object)key, (Object)(indexL + 1), (Object[])new Object[]{sizeKeys, this.mergeMode ? this.mergedNb : tmpEntityDuplicates.size()});
                    if (!this.error && this.mergeMode && !tmpEntityDuplicates.isEmpty()) {
                        this.error = true;
                    }
                    if (this.cancel) {
                        if (this.log != null) {
                            this.log.error(NbBundle.getMessage(SearchDuplicatesAction.class, (String)"MassMergeEntitiesTask.abortRequeted"));
                        }
                        return this.sortAndCutList(tmpEntityDuplicates, this.batchsize);
                    }
                    if (tmpEntityDuplicates.size() <= 3 * this.batchsize) continue;
                    return this.sortAndCutList(tmpEntityDuplicates, this.batchsize);
                }
            }
            return this.sortAndCutList(tmpEntityDuplicates, this.batchsize);
        }

        @Override
        public List<PotentialMatch<? extends Entity>> getResult() {
            return new ArrayList<PotentialMatch<? extends Entity>>(EntityMatcher.this.entityDuplicates);
        }

        public boolean getExcludedNonDup() {
            return EntityMatcher.this.excludedNonDup;
        }

        public int getMergedNb() {
            return this.mergedNb;
        }

        public void setValues(Log log, DuplicatesResults aThis, int startingKey) {
            this.log = log;
            this.tool = aThis;
            this.startingKey = startingKey;
        }

        public boolean getCancelled() {
            return this.cancel;
        }

        public boolean getError() {
            return this.error;
        }

        public int getClustersProcessed() {
            return this.dupProgress;
        }

        private List<PotentialMatch<E>> sortAndCutList(List<PotentialMatch<E>> list, int size) {
            Collections.sort(list, (e1, e2) -> e2.getCertainty() - e1.getCertainty());
            return list.subList(0, Math.min(size, list.size()));
        }
    }

    protected static class NameData {
        private String id;
        private String fullname;
        protected String lastName;
        protected String firstName;
        protected List<String> lastNames;
        protected List<String> firstNames;
        private boolean valid = false;

        public NameData(Indi indi) {
            this.lastName = GedcomUtilities.normalizeAndReduce((String)indi.getLastName());
            this.firstName = GedcomUtilities.normalizeAndReduce((String)indi.getFirstName());
            this.fullname = GedcomUtilities.normalizeAndReduce((String)(this.lastName + " " + this.firstName));
            if (this.fullname.isBlank()) {
                this.lastNames = null;
                this.firstNames = null;
                this.firstName = null;
                this.valid = false;
            } else {
                String[] lnArray = GedcomUtilities.normalizeAndReduce((String[])indi.getLastNames(), (boolean)false);
                String[] fnArray = GedcomUtilities.normalizeAndReduce((String[])indi.getFirstNames(), (boolean)true);
                this.lastNames = Arrays.asList(lnArray);
                this.firstNames = Arrays.asList(fnArray);
                this.valid = !this.lastNames.isEmpty();
            }
        }

        public int isValid() {
            return this.valid ? 1 : 0;
        }
    }

    protected static class DateData {
        protected String dateDisplayValue;
        private boolean dateIsRange;
        private boolean dateIsComplete;
        private boolean dateIsYearOnly;
        protected int dateYear;
        private int dateStartJD;
        private int dateEndJD;
        private boolean valid = false;

        public DateData(PropertyDate date) {
            this.dateDisplayValue = date.getDisplayValue((Calendar)PointInTime.GREGORIAN);
            this.dateIsRange = date.isRange();
            PointInTime pit = date.getStart();
            this.dateYear = pit.getYear();
            if (this.dateYear != 0 && this.dateYear < 3000) {
                this.dateIsYearOnly = pit.isYearOnly();
                this.dateIsComplete = pit.isComplete();
                try {
                    this.dateStartJD = pit.getJulianDay();
                    this.dateEndJD = this.dateIsRange ? date.getEnd().getJulianDay() : this.dateStartJD;
                    this.valid = true;
                }
                catch (GedcomException ex) {
                    this.valid = false;
                }
            } else {
                this.valid = false;
            }
        }

        public int isValid() {
            return this.valid ? 1 : 0;
        }
    }

    protected static class PlaceData {
        protected String placeDisplayValue;
        private String country;
        private String city;
        private boolean valid = false;

        public PlaceData(PropertyPlace place) {
            this.placeDisplayValue = GedcomUtilities.normalizeAndReduce((String)place.getValue());
            if (this.placeDisplayValue.isBlank()) {
                this.valid = false;
            } else {
                this.country = GedcomUtilities.normalizeAndReduce((String)place.getCountry());
                this.city = GedcomUtilities.normalizeAndReduce((String)place.getCity());
                this.valid = true;
            }
        }

        public int isValid() {
            return this.valid ? 1 : 0;
        }
    }
}

