/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.searchdupes;

import ancestris.gedcom.GedcomDirectory;
import ancestris.modules.gedcom.matchers.MatcherOptions;
import ancestris.modules.gedcom.matchers.MatcherOptionsPanel;
import ancestris.modules.gedcom.searchdupes.NonDupManagerPanel;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomConstants;
import genj.util.Registry;
import genj.view.Images;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class SearchDuplicatesPanel
extends JPanel {
    private Registry registry = null;
    private Gedcom gedcom = null;
    private JButton OKButton = null;
    private final LinkedHashMap<String, JCheckBox> entitiesChoices = new LinkedHashMap();
    private final Map<String, JButton> entitiesButtons = new HashMap<String, JButton>();
    private final Map<String, MatcherOptions> selectedOptions = new HashMap<String, MatcherOptions>();
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButton5;
    private JButton jButton6;
    private JButton jButton7;
    private JButton jButton8;
    private JCheckBox jCheckBox1;
    private JCheckBox jCheckBox2;
    private JCheckBox jCheckBox3;
    private JCheckBox jCheckBox4;
    private JCheckBox jCheckBox5;
    private JCheckBox jCheckBox6;
    private JCheckBox jCheckBox7;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabelSelect;
    private JLabel jLabelText;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JCheckBox nonDupCheckBox;

    public SearchDuplicatesPanel(Gedcom gedcom, JButton OKButton) {
        if (gedcom == null) {
            gedcom = GedcomDirectory.getDefault().getDefaultContext().getGedcom();
        }
        this.gedcom = gedcom;
        this.OKButton = OKButton;
        this.registry = Registry.get(this.getClass());
        String NOTE_TAG = gedcom.isGrammar7() ? "SNOTE" : "NOTE";
        this.initComponents();
        this.entitiesChoices.put("INDI", this.jCheckBox1);
        this.entitiesChoices.put("FAM", this.jCheckBox2);
        this.entitiesChoices.put("SUBM", this.jCheckBox3);
        this.entitiesChoices.put("REPO", this.jCheckBox4);
        this.entitiesChoices.put("SOUR", this.jCheckBox5);
        this.entitiesChoices.put(NOTE_TAG, this.jCheckBox6);
        this.entitiesChoices.put("OBJE", this.jCheckBox7);
        this.entitiesButtons.put("INDI", this.jButton1);
        this.entitiesButtons.put("FAM", this.jButton2);
        this.entitiesButtons.put("SUBM", this.jButton3);
        this.entitiesButtons.put("REPO", this.jButton4);
        this.entitiesButtons.put("SOUR", this.jButton5);
        this.entitiesButtons.put(NOTE_TAG, this.jButton6);
        this.entitiesButtons.put("OBJE", this.jButton7);
        this.jLabel1.setText("");
        this.jLabel1.setIcon((Icon)GedcomConstants.getEntityImage((String)"INDI"));
        this.jLabel2.setText("");
        this.jLabel2.setIcon((Icon)GedcomConstants.getEntityImage((String)"FAM"));
        this.jLabel3.setText("");
        this.jLabel3.setIcon((Icon)GedcomConstants.getEntityImage((String)"SUBM"));
        this.jLabel4.setText("");
        this.jLabel4.setIcon((Icon)GedcomConstants.getEntityImage((String)"REPO"));
        this.jLabel5.setText("");
        this.jLabel5.setIcon((Icon)GedcomConstants.getEntityImage((String)"SOUR"));
        this.jLabel6.setText("");
        this.jLabel6.setIcon((Icon)GedcomConstants.getEntityImage((String)"NOTE"));
        this.jLabel7.setText("");
        this.jLabel7.setIcon((Icon)GedcomConstants.getEntityImage((String)"OBJE"));
        for (String entityTag : this.entitiesChoices.keySet()) {
            JCheckBox cb = this.entitiesChoices.get(entityTag);
            int size = gedcom.getEntities(entityTag).size();
            cb.setText(Gedcom.getName((String)entityTag) + " (" + size + ")");
            cb.setEnabled(size > 0);
            cb.setSelected(size > 0 && this.registry.get("duplicateSelected." + entityTag, entityTag.equals("INDI")));
            JButton b = this.entitiesButtons.get(entityTag);
            b.setIcon((Icon)Images.imgSettings);
            b.setText("");
            b.setToolTipText(NbBundle.getMessage(SearchDuplicatesPanel.class, (String)"SearchDuplicatesPanel.jButton.text"));
            b.setEnabled(size > 0);
            cb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SearchDuplicatesPanel.this.setButton();
                }
            });
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SearchDuplicatesPanel.this.openCriteria((JButton)e.getSource());
                }
            });
            b.setVisible(false);
        }
        this.nonDupCheckBox.setSelected(this.registry.get("duplicateExcludeNonDup", true));
        this.setButton();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.jLabelText = new JLabel();
        this.jLabelSelect = new JLabel();
        this.jLabel1 = new JLabel();
        this.jCheckBox1 = new JCheckBox();
        this.jButton1 = new JButton();
        this.jLabel2 = new JLabel();
        this.jCheckBox2 = new JCheckBox();
        this.jButton2 = new JButton();
        this.jLabel3 = new JLabel();
        this.jCheckBox3 = new JCheckBox();
        this.jButton3 = new JButton();
        this.jLabel4 = new JLabel();
        this.jCheckBox4 = new JCheckBox();
        this.jButton4 = new JButton();
        this.jLabel5 = new JLabel();
        this.jCheckBox5 = new JCheckBox();
        this.jButton5 = new JButton();
        this.jLabel6 = new JLabel();
        this.jCheckBox6 = new JCheckBox();
        this.jButton6 = new JButton();
        this.jLabel7 = new JLabel();
        this.jCheckBox7 = new JCheckBox();
        this.jButton7 = new JButton();
        this.nonDupCheckBox = new JCheckBox();
        this.jButton8 = new JButton();
        this.setPreferredSize(new Dimension(440, 468));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                SearchDuplicatesPanel.this.formComponentResized(evt);
            }
        });
        this.jScrollPane1.setPreferredSize(new Dimension(446, 359));
        this.jPanel1.setPreferredSize(new Dimension(430, 440));
        this.jLabelText.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcom/searchdupes/CheckDuplicateIcon24.png")));
        Mnemonics.setLocalizedText((JLabel)this.jLabelText, (String)NbBundle.getMessage(SearchDuplicatesPanel.class, (String)"SearchDuplicatesPanel.jLabelText.text"));
        this.jLabelSelect.setFont(this.jLabelSelect.getFont().deriveFont(this.jLabelSelect.getFont().getStyle() | 1));
        Mnemonics.setLocalizedText((JLabel)this.jLabelSelect, (String)NbBundle.getMessage(SearchDuplicatesPanel.class, (String)"SearchDuplicatesPanel.jLabelSelect.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(SearchDuplicatesPanel.class, (String)"SearchDuplicatesPanel.jLabel1.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBox1, (String)NbBundle.getMessage(SearchDuplicatesPanel.class, (String)"SearchDuplicatesPanel.jCheckBox1.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(SearchDuplicatesPanel.class, (String)"SearchDuplicatesPanel.jButton1.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(SearchDuplicatesPanel.class, (String)"SearchDuplicatesPanel.jLabel2.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBox2, (String)NbBundle.getMessage(SearchDuplicatesPanel.class, (String)"SearchDuplicatesPanel.jCheckBox2.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton2, (String)NbBundle.getMessage(SearchDuplicatesPanel.class, (String)"SearchDuplicatesPanel.jButton2.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(SearchDuplicatesPanel.class, (String)"SearchDuplicatesPanel.jLabel3.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBox3, (String)NbBundle.getMessage(SearchDuplicatesPanel.class, (String)"SearchDuplicatesPanel.jCheckBox3.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton3, (String)NbBundle.getMessage(SearchDuplicatesPanel.class, (String)"SearchDuplicatesPanel.jButton3.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(SearchDuplicatesPanel.class, (String)"SearchDuplicatesPanel.jLabel4.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBox4, (String)NbBundle.getMessage(SearchDuplicatesPanel.class, (String)"SearchDuplicatesPanel.jCheckBox4.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton4, (String)NbBundle.getMessage(SearchDuplicatesPanel.class, (String)"SearchDuplicatesPanel.jButton4.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(SearchDuplicatesPanel.class, (String)"SearchDuplicatesPanel.jLabel5.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBox5, (String)NbBundle.getMessage(SearchDuplicatesPanel.class, (String)"SearchDuplicatesPanel.jCheckBox5.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton5, (String)NbBundle.getMessage(SearchDuplicatesPanel.class, (String)"SearchDuplicatesPanel.jButton5.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(SearchDuplicatesPanel.class, (String)"SearchDuplicatesPanel.jLabel6.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBox6, (String)NbBundle.getMessage(SearchDuplicatesPanel.class, (String)"SearchDuplicatesPanel.jCheckBox6.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton6, (String)NbBundle.getMessage(SearchDuplicatesPanel.class, (String)"SearchDuplicatesPanel.jButton6.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(SearchDuplicatesPanel.class, (String)"SearchDuplicatesPanel.jLabel7.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBox7, (String)NbBundle.getMessage(SearchDuplicatesPanel.class, (String)"SearchDuplicatesPanel.jCheckBox7.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton7, (String)NbBundle.getMessage(SearchDuplicatesPanel.class, (String)"SearchDuplicatesPanel.jButton7.text"));
        this.nonDupCheckBox.setFont(this.nonDupCheckBox.getFont().deriveFont(this.nonDupCheckBox.getFont().getStyle() | 1));
        this.nonDupCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.nonDupCheckBox, (String)NbBundle.getMessage(SearchDuplicatesPanel.class, (String)"SearchDuplicatesPanel.nonDupCheckBox.text"));
        this.nonDupCheckBox.setToolTipText(NbBundle.getMessage(SearchDuplicatesPanel.class, (String)"SearchDuplicatesPanel.nonDupCheckBox.toolTipText"));
        this.nonDupCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchDuplicatesPanel.this.nonDupCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jButton8, (String)NbBundle.getMessage(SearchDuplicatesPanel.class, (String)"SearchDuplicatesPanel.jButton8.text"));
        this.jButton8.setToolTipText(NbBundle.getMessage(SearchDuplicatesPanel.class, (String)"SearchDuplicatesPanel.jButton8.toolTipText"));
        this.jButton8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchDuplicatesPanel.this.jButton8ActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.jLabelText, -2, 0, Short.MAX_VALUE).addContainerGap()).addGroup(jPanel1Layout.createSequentialGroup().addGap(28, 28, 28).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelSelect).addGroup(jPanel1Layout.createSequentialGroup().addGap(6, 6, 6).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel4).addComponent(this.jLabel5).addComponent(this.jLabel6).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox2).addComponent(this.jCheckBox1).addComponent(this.jCheckBox3).addComponent(this.jCheckBox6).addComponent(this.jCheckBox7).addComponent(this.jCheckBox4).addComponent(this.jCheckBox5)).addGap(40, 40, 40).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton3).addComponent(this.jButton4).addComponent(this.jButton5).addComponent(this.jButton6).addComponent(this.jButton7).addComponent(this.jButton1).addComponent(this.jButton2))).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.nonDupCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton8))))).addContainerGap(68, Short.MAX_VALUE)))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabelText, -2, -1, -2).addGap(24, 24, 24).addComponent(this.jLabelSelect).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel1).addComponent(this.jCheckBox1).addComponent(this.jButton1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel2).addComponent(this.jCheckBox2).addComponent(this.jButton2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel3).addComponent(this.jCheckBox3).addComponent(this.jButton3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel4).addComponent(this.jCheckBox4).addComponent(this.jButton4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel5).addComponent(this.jCheckBox5).addComponent(this.jButton5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel6).addComponent(this.jCheckBox6).addComponent(this.jButton6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel7).addComponent(this.jCheckBox7).addComponent(this.jButton7)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nonDupCheckBox).addComponent(this.jButton8)).addContainerGap(192, Short.MAX_VALUE)));
        this.jScrollPane1.setViewportView(this.jPanel1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 465, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 561, Short.MAX_VALUE).addGap(0, 0, 0)));
    }

    private void formComponentResized(ComponentEvent evt) {
    }

    private void jButton8ActionPerformed(ActionEvent evt) {
        this.showNonDupPanel();
    }

    private void nonDupCheckBoxActionPerformed(ActionEvent evt) {
        this.registry.put("duplicateExcludeNonDup", Boolean.valueOf(this.nonDupCheckBox.isSelected()));
    }

    public List<String> getEntitiesToCheck() {
        ArrayList<String> ret = new ArrayList<String>();
        for (String entityTag : this.entitiesChoices.keySet()) {
            JCheckBox cb = this.entitiesChoices.get(entityTag);
            if (!cb.isSelected()) continue;
            ret.add(entityTag);
        }
        return ret;
    }

    public Map<String, MatcherOptions> getSelectedOptions() {
        for (String entityTag : this.entitiesChoices.keySet()) {
            JCheckBox cb = this.entitiesChoices.get(entityTag);
            if (!cb.isSelected()) continue;
            this.selectedOptions.put(entityTag, new MatcherOptionsPanel(entityTag).getMatcherOptions());
        }
        return this.selectedOptions;
    }

    private void setButton() {
        boolean activated = false;
        for (String entityTag : this.entitiesChoices.keySet()) {
            JCheckBox cb = this.entitiesChoices.get(entityTag);
            activated |= cb.isSelected();
            this.registry.put("duplicateSelected." + entityTag, Boolean.valueOf(cb.isSelected()));
        }
        this.OKButton.setEnabled(activated);
    }

    private void openCriteria(JButton b) {
        for (String entityTag : this.entitiesButtons.keySet()) {
            JButton readB = this.entitiesButtons.get(entityTag);
            if (!b.equals(readB)) continue;
            MatcherOptionsPanel panel = new MatcherOptionsPanel(entityTag);
            Object o = DialogManager.create((String)NbBundle.getMessage(MatcherOptionsPanel.class, (String)"CTL_MatcherOptionsTitle"), (JComponent)panel).setMessageType(-1).setOptions(new Object[]{DialogManager.OK_OPTION, DialogManager.CANCEL_OPTION}).show();
            if (o != DialogManager.OK_OPTION) {
                return;
            }
            this.selectedOptions.put(entityTag, panel.getMatcherOptions());
        }
    }

    protected boolean getNonDupExclusion() {
        return this.nonDupCheckBox.isSelected();
    }

    private void showNonDupPanel() {
        NonDupManagerPanel panel = new NonDupManagerPanel(this.gedcom);
        Object o = DialogManager.create((String)NbBundle.getMessage(NonDupManagerPanel.class, (String)"NonDupManagerPanel.Title"), (JComponent)panel).setMessageType(-1).setOptionType(2).setDialogId(NonDupManagerPanel.class).show();
        if (o == DialogManager.OK_OPTION) {
            panel.saveList();
        }
        panel.close();
    }
}

