/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.placeeditor.topcomponents;

import ancestris.modules.editors.placeeditor.topcomponents.CellsData;
import ancestris.modules.editors.placeeditor.topcomponents.EditorTable;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;

public class CellsTransferHandler
extends TransferHandler {
    private EditorTable editor;

    public CellsTransferHandler() {
    }

    public CellsTransferHandler(EditorTable editor) {
        this.editor = editor;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        this.editor.setpendingPaste(false);
        return new CellsData(this.editor.exportData());
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        return support.isDataFlavorSupported(CellsData.CELL_DATA_FLAVOR);
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (!this.canImport(support) || !support.isDrop()) {
            return false;
        }
        Object[][] data = null;
        try {
            data = (Object[][])support.getTransferable().getTransferData(CellsData.CELL_DATA_FLAVOR);
        }
        catch (UnsupportedFlavorException ufe) {
            System.out.println("importData: unsupported data flavor");
            return false;
        }
        catch (IOException ioe) {
            System.out.println("importData: I/O exception");
            return false;
        }
        if ((2 & support.getDropAction()) == 2) {
            this.editor.eraseSelection();
        }
        JTable.DropLocation dl = (JTable.DropLocation)support.getDropLocation();
        int[] rows = new int[]{dl.getRow()};
        int[] cols = new int[]{dl.getColumn()};
        this.editor.importData(data, rows, cols);
        return true;
    }
}

