/*
 * Decompiled with CFR 0.152.
 */
package genj.tree;

import ancestris.modules.views.tree.style.Style;
import ancestris.modules.views.tree.style.TreeStyleManager;
import ancestris.util.TimingUtility;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Entity;
import genj.tree.Bookmark;
import genj.tree.BookmarkSeparator;
import genj.tree.TreeMetrics;
import genj.tree.TreeView;
import genj.util.Resources;
import genj.util.swing.ColorsWidget;
import genj.util.swing.FontChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class TreeViewSettings
extends JPanel {
    private static final Resources RESOURCES = Resources.get(TreeViewSettings.class);
    private final TreeView view;
    private final Commit commit;
    private final Styles styles;
    private final Styles horizontalStyles;
    private final Bookmarks bookmarks;
    private final ColorsWidget colors;
    private boolean busy = true;
    private static final double MAXSIZE = 30.0;
    private static final double MAXPAD = 5.0;
    private static final int MAXTHICKNESS = 9;
    private int tabIndex = 0;
    private JCheckBox antialiasingCheckBox;
    private JSpinner bFamSpinner;
    private JSpinner bIndiSpinner;
    private JList<String> bList;
    private JCheckBox bendCheckBox;
    private JPanel bookmarksPanel;
    private JLabel borderLabel;
    private JLabel boxesLabel;
    private JCheckBox cbShowPopup;
    private JCheckBox cbTreeAutoScroll;
    private JPanel colorsPanel;
    private JButton delButton;
    private JLabel displayLabel;
    private JLabel douclickLabel;
    private JButton downButton;
    private JLabel famLabel;
    private FontChooser fontChooser;
    private JLabel fontLabel;
    private JSpinner hFamSpinner;
    private JSpinner hIndiSpinner;
    private JLabel heightLabel;
    private JLabel horizontalLabel;
    private JLabel indiLabel;
    private JCheckBox jCbHorizontalStyle;
    private JLabel jLabel1;
    private JList<Style> jListHorizontalStyle;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JSpinner jSpinnerDesc;
    private JTabbedPane jTabbedPane1;
    private JComboBox<OnAction> jcAction;
    private JPanel mainPanel;
    private JCheckBox marrsymbolsCheckBox;
    private JLabel maxGenLabel;
    private JLabel navigationLabel;
    private JLabel paddingLabel;
    private JSpinner paddingSpinner;
    private JCheckBox roundedRectanglesCheckBox;
    private JButton separatorButton;
    private JSpinner spingen;
    private JLabel styleLabel;
    private JList<Style> stylesList;
    private JPanel tuningPanel;
    private JButton upButton;
    private JLabel verticalLabel;
    private JSpinner wFamSpinner;
    private JSpinner wIndiSpinner;
    private JLabel widthLabel;

    public TreeViewSettings(TreeView view, int index) {
        TimingUtility.getInstance().reset();
        this.view = view;
        this.tabIndex = index;
        this.commit = new Commit(view);
        this.styles = new Styles(view.getStyleManager().getStyles(true));
        this.styles.addListDataListener(this.commit);
        this.horizontalStyles = new Styles(view.getStyleManager().getStyles(false));
        this.horizontalStyles.addListDataListener(this.commit);
        this.bookmarks = new Bookmarks(view.getModel().getBookmarks());
        this.bookmarks.addListDataListener(this.commit);
        this.initComponents();
        this.busy = true;
        this.cbTreeAutoScroll.setSelected(TreeView.isAutoScroll());
        this.jcAction.setSelectedItem((Object)TreeView.getOnAction());
        this.spingen.setValue(view.getModel().getMaxAscendants());
        this.jSpinnerDesc.setValue(view.getModel().getMaxDescendants());
        this.cbShowPopup.setSelected(TreeView.showPopup());
        this.jCbHorizontalStyle.setSelected(view.getModel().useHorizontalStyle());
        this.stylesList.setCellRenderer(new ListEntryCellRenderer());
        this.stylesList.setSelectedValue(view.getVStyle(), true);
        this.stylesList.setEnabled(!this.jCbHorizontalStyle.isSelected() || !this.view.getModel().ishorizontalStyle());
        this.setStyleVisibility();
        this.jListHorizontalStyle.setCellRenderer(new ListEntryCellRenderer());
        this.jListHorizontalStyle.setSelectedValue(view.getHStyle(), true);
        this.jListHorizontalStyle.setEnabled(this.jCbHorizontalStyle.isSelected() && this.view.getModel().ishorizontalStyle());
        this.fontChooser.setCallBack(() -> {
            this.busy = true;
            this.fontChooser.setSelectedFont(view.getStyle().font);
            this.busy = false;
        });
        this.colors = new ColorsWidget();
        for (String key : TreeStyleManager.ORDERCOLORS) {
            this.colors.addColor(key, RESOURCES.getString("color." + key), view.getColors().get(key));
        }
        this.colorsPanel.add((Component)this.colors);
        this.bendCheckBox.setSelected(view.getModel().isBendArcs());
        this.marrsymbolsCheckBox.setSelected(view.getModel().isMarrSymbols());
        this.antialiasingCheckBox.setSelected(view.isAntialising());
        this.roundedRectanglesCheckBox.setSelected(view.getModel().isRoundedRectangle());
        TreeMetrics m = view.getModel().getMetrics();
        this.initSpinner(this.wIndiSpinner, 0.4, (double)m.wIndis * 0.1, 30.0, 0.1);
        this.initSpinner(this.hIndiSpinner, 0.4, (double)m.hIndis * 0.1, 30.0, 0.1);
        this.initSpinner(this.wFamSpinner, 0.4, (double)m.wFams * 0.1, 30.0, 0.1);
        this.initSpinner(this.hFamSpinner, 0.4, (double)m.hFams * 0.1, 30.0, 0.1);
        this.initSpinner(this.paddingSpinner, 0.4, (double)m.pad * 0.1, 5.0, 0.1);
        this.bIndiSpinner.setModel(new SpinnerNumberModel(m.indisThick, 1, 9, 1));
        this.bFamSpinner.setModel(new SpinnerNumberModel(m.famsThick, 1, 9, 1));
        this.bList.getModel().addListDataListener(this.commit);
        this.colors.addChangeListener((ChangeListener)this.commit);
        this.fontChooser.addChangeListener((ChangeListener)this.commit);
        this.jTabbedPane1.setSelectedIndex(this.tabIndex);
        this.busy = false;
    }

    private void initSpinner(JSpinner spinner, double min, double val, double max, double inc) {
        val = Math.min(max, Math.max(val, min));
        spinner.setModel(new SpinnerNumberModel(val, min, max, inc));
        JSpinner.NumberEditor editor = new JSpinner.NumberEditor(spinner, inc < 1.0 ? "##0.0" : "0");
        spinner.setEditor(editor);
        spinner.addChangeListener(editor);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTabbedPane1 = new JTabbedPane();
        this.mainPanel = new JPanel();
        this.navigationLabel = new JLabel();
        this.cbTreeAutoScroll = new JCheckBox();
        this.douclickLabel = new JLabel();
        this.jcAction = new JComboBox();
        this.maxGenLabel = new JLabel();
        this.spingen = new JSpinner(new SpinnerNumberModel(this.view.getModel().getMaxAscendants(), 1, 100, 1));
        this.cbShowPopup = new JCheckBox();
        this.styleLabel = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.stylesList = new JList();
        this.jScrollPane4 = new JScrollPane();
        this.jListHorizontalStyle = new JList();
        this.jSpinnerDesc = new JSpinner(new SpinnerNumberModel(this.view.getModel().getMaxDescendants(), 1, 100, 1));
        this.jLabel1 = new JLabel();
        this.jCbHorizontalStyle = new JCheckBox();
        this.verticalLabel = new JLabel();
        this.horizontalLabel = new JLabel();
        this.bookmarksPanel = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.bList = new JList();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.delButton = new JButton();
        this.separatorButton = new JButton();
        this.colorsPanel = new JPanel();
        this.tuningPanel = new JPanel();
        this.fontLabel = new JLabel();
        this.fontChooser = new FontChooser();
        this.displayLabel = new JLabel();
        this.bendCheckBox = new JCheckBox();
        this.marrsymbolsCheckBox = new JCheckBox();
        this.antialiasingCheckBox = new JCheckBox();
        this.boxesLabel = new JLabel();
        this.roundedRectanglesCheckBox = new JCheckBox();
        this.paddingLabel = new JLabel();
        this.paddingSpinner = new JSpinner();
        this.indiLabel = new JLabel();
        this.famLabel = new JLabel();
        this.widthLabel = new JLabel();
        this.heightLabel = new JLabel();
        this.borderLabel = new JLabel();
        this.wIndiSpinner = new JSpinner();
        this.hIndiSpinner = new JSpinner();
        this.bIndiSpinner = new JSpinner();
        this.wFamSpinner = new JSpinner();
        this.hFamSpinner = new JSpinner();
        this.bFamSpinner = new JSpinner();
        this.jScrollPane1.setPreferredSize(new Dimension(400, 400));
        this.jTabbedPane1.setPreferredSize(new Dimension(350, 400));
        this.navigationLabel.setFont(new Font("DejaVu Sans", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.navigationLabel, (String)NbBundle.getMessage(TreeViewSettings.class, (String)"TreeViewSettings.navigationLabel.text"));
        this.cbTreeAutoScroll.setSelected(TreeView.isAutoScroll());
        Mnemonics.setLocalizedText((AbstractButton)this.cbTreeAutoScroll, (String)NbBundle.getMessage(TreeViewSettings.class, (String)"TreeViewSettings.cbTreeAutoScroll.text"));
        this.cbTreeAutoScroll.setToolTipText(NbBundle.getMessage(TreeViewSettings.class, (String)"TreeViewSettings.cbTreeAutoScroll.toolTipText"));
        this.cbTreeAutoScroll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreeViewSettings.this.cbTreeAutoScrollActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.douclickLabel, (String)NbBundle.getMessage(TreeViewSettings.class, (String)"TreeViewSettings.douclickLabel.text"));
        this.douclickLabel.setToolTipText(NbBundle.getMessage(TreeViewSettings.class, (String)"TreeViewSettings.douclickLabel.toolTipText"));
        this.jcAction.setModel(new DefaultComboBoxModel<OnAction>(OnAction.values()));
        this.jcAction.setToolTipText(NbBundle.getMessage(TreeViewSettings.class, (String)"TreeViewSettings.jcAction.toolTipText"));
        this.jcAction.setSelectedItem((Object)TreeView.getOnAction());
        this.jcAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreeViewSettings.this.jcActionActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.maxGenLabel, (String)NbBundle.getMessage(TreeViewSettings.class, (String)"TreeViewSettings.maxGenLabel.text"));
        this.maxGenLabel.setToolTipText(NbBundle.getMessage(TreeViewSettings.class, (String)"TreeViewSettings.maxGenLabel.toolTipText"));
        this.spingen.setToolTipText(NbBundle.getMessage(TreeViewSettings.class, (String)"TreeViewSettings.spingen.toolTipText"));
        this.spingen.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TreeViewSettings.this.spingenStateChanged(evt);
            }
        });
        this.cbShowPopup.setSelected(TreeView.showPopup());
        Mnemonics.setLocalizedText((AbstractButton)this.cbShowPopup, (String)NbBundle.getMessage(TreeViewSettings.class, (String)"TreeViewSettings.cbShowPopup.text"));
        this.cbShowPopup.setToolTipText(NbBundle.getMessage(TreeViewSettings.class, (String)"TreeViewSettings.cbShowPopup.toolTipText"));
        this.cbShowPopup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreeViewSettings.this.cbShowPopupActionPerformed(evt);
            }
        });
        this.styleLabel.setFont(new Font("DejaVu Sans", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.styleLabel, (String)NbBundle.getMessage(TreeViewSettings.class, (String)"TreeViewSettings.styleLabel.text"));
        this.jScrollPane2.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.stylesList.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.stylesList.setModel(this.styles);
        this.stylesList.setSelectionMode(0);
        this.stylesList.setLayoutOrientation(2);
        this.stylesList.setOpaque(false);
        this.stylesList.setVisibleRowCount(-1);
        this.stylesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                TreeViewSettings.this.stylesListValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.stylesList);
        this.jScrollPane4.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jListHorizontalStyle.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jListHorizontalStyle.setModel(this.horizontalStyles);
        this.jListHorizontalStyle.setSelectionMode(0);
        this.jListHorizontalStyle.setLayoutOrientation(2);
        this.jListHorizontalStyle.setOpaque(false);
        this.jListHorizontalStyle.setVisibleRowCount(-1);
        this.jListHorizontalStyle.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                TreeViewSettings.this.jListHorizontalStyleValueChanged(evt);
            }
        });
        this.jScrollPane4.setViewportView(this.jListHorizontalStyle);
        this.jSpinnerDesc.setToolTipText(NbBundle.getMessage(TreeViewSettings.class, (String)"TreeViewSettings.jSpinnerDesc.toolTipText"));
        this.jSpinnerDesc.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TreeViewSettings.this.jSpinnerDescStateChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(TreeViewSettings.class, (String)"TreeViewSettings.jLabel1.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jCbHorizontalStyle, (String)NbBundle.getMessage(TreeViewSettings.class, (String)"TreeViewSettings.jCbHorizontalStyle.text"));
        this.jCbHorizontalStyle.setToolTipText(NbBundle.getMessage(TreeViewSettings.class, (String)"TreeViewSettings.jCbHorizontalStyle.toolTipText"));
        this.jCbHorizontalStyle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreeViewSettings.this.jCbHorizontalStyleActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.verticalLabel, (String)NbBundle.getMessage(TreeViewSettings.class, (String)"TreeViewSettings.verticalLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.horizontalLabel, (String)NbBundle.getMessage(TreeViewSettings.class, (String)"TreeViewSettings.horizontalLabel.text"));
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2).addComponent(this.jScrollPane4)).addGap(15, 15, 15)).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGap(6, 6, 6).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbTreeAutoScroll, -1, -1, Short.MAX_VALUE).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbShowPopup).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.douclickLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jcAction, -2, -1, -2)).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.maxGenLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spingen, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinnerDesc, -2, -1, -2))).addGap(0, 14, Short.MAX_VALUE)))).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.navigationLabel).addComponent(this.styleLabel, -2, 207, -2)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()).addGroup(mainPanelLayout.createSequentialGroup().addGap(6, 6, 6).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCbHorizontalStyle, -1, -1, Short.MAX_VALUE).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.verticalLabel).addComponent(this.horizontalLabel)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()))));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.navigationLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbTreeAutoScroll).addGap(7, 7, 7).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jcAction, -2, -1, -2).addComponent(this.douclickLabel)).addGap(2, 2, 2).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxGenLabel).addComponent(this.spingen, -2, 28, -2).addComponent(this.jSpinnerDesc, -2, 28, -2).addComponent(this.jLabel1)).addGap(6, 6, 6).addComponent(this.cbShowPopup).addGap(18, 18, 18).addComponent(this.styleLabel).addGap(3, 3, 3).addComponent(this.jCbHorizontalStyle).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.verticalLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 78, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.horizontalLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane4, -1, 85, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab(NbBundle.getMessage(TreeViewSettings.class, (String)"TreeViewSettings.mainPanel.TabConstraints.tabTitle"), this.mainPanel);
        this.bList.setModel(this.bookmarks);
        this.bList.setSelectionMode(0);
        this.bList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                TreeViewSettings.this.bListValueChanged(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.bList);
        Mnemonics.setLocalizedText((AbstractButton)this.upButton, (String)NbBundle.getMessage(TreeViewSettings.class, (String)"TreeViewSettings.upButton.text"));
        this.upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreeViewSettings.this.upButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.downButton, (String)NbBundle.getMessage(TreeViewSettings.class, (String)"TreeViewSettings.downButton.text"));
        this.downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreeViewSettings.this.downButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.delButton, (String)NbBundle.getMessage(TreeViewSettings.class, (String)"TreeViewSettings.delButton.text"));
        this.delButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreeViewSettings.this.delButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.separatorButton, (String)NbBundle.getMessage(TreeViewSettings.class, (String)"TreeViewSettings.separatorButton.text"));
        this.separatorButton.setToolTipText(NbBundle.getMessage(TreeViewSettings.class, (String)"TreeViewSettings.separatorButton.toolTipText"));
        this.separatorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreeViewSettings.this.separatorButtonActionPerformed(evt);
            }
        });
        GroupLayout bookmarksPanelLayout = new GroupLayout(this.bookmarksPanel);
        this.bookmarksPanel.setLayout(bookmarksPanelLayout);
        bookmarksPanelLayout.setHorizontalGroup(bookmarksPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane3, -1, 422, Short.MAX_VALUE).addGroup(bookmarksPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.upButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.downButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.delButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.separatorButton).addContainerGap()));
        bookmarksPanelLayout.setVerticalGroup(bookmarksPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(bookmarksPanelLayout.createSequentialGroup().addComponent(this.jScrollPane3, -1, 379, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(bookmarksPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.upButton).addComponent(this.downButton).addComponent(this.delButton).addComponent(this.separatorButton)).addContainerGap()));
        this.jTabbedPane1.addTab(NbBundle.getMessage(TreeViewSettings.class, (String)"TreeViewSettings.bookmarksPanel.TabConstraints.tabTitle"), this.bookmarksPanel);
        this.colorsPanel.setLayout(new BorderLayout());
        this.jTabbedPane1.addTab(NbBundle.getMessage(TreeViewSettings.class, (String)"TreeViewSettings.colorsPanel.TabConstraints.tabTitle"), this.colorsPanel);
        this.tuningPanel.setPreferredSize(new Dimension(400, 300));
        this.fontLabel.setFont(new Font("DejaVu Sans", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.fontLabel, (String)NbBundle.getMessage(TreeViewSettings.class, (String)"TreeViewSettings.fontLabel.text"));
        this.fontChooser.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TreeViewSettings.this.fontChooserStateChanged(evt);
            }
        });
        this.displayLabel.setFont(new Font("DejaVu Sans", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.displayLabel, (String)NbBundle.getMessage(TreeViewSettings.class, (String)"TreeViewSettings.displayLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.bendCheckBox, (String)NbBundle.getMessage(TreeViewSettings.class, (String)"TreeViewSettings.bendCheckBox.text"));
        this.bendCheckBox.setToolTipText(NbBundle.getMessage(TreeViewSettings.class, (String)"TreeViewSettings.bendCheckBox.toolTipText"));
        this.bendCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreeViewSettings.this.bendCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.marrsymbolsCheckBox, (String)NbBundle.getMessage(TreeViewSettings.class, (String)"TreeViewSettings.marrsymbolsCheckBox.text"));
        this.marrsymbolsCheckBox.setToolTipText(NbBundle.getMessage(TreeViewSettings.class, (String)"TreeViewSettings.marrsymbolsCheckBox.toolTipText"));
        this.marrsymbolsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreeViewSettings.this.marrsymbolsCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.antialiasingCheckBox, (String)NbBundle.getMessage(TreeViewSettings.class, (String)"TreeViewSettings.antialiasingCheckBox.text"));
        this.antialiasingCheckBox.setToolTipText(NbBundle.getMessage(TreeViewSettings.class, (String)"TreeViewSettings.antialiasingCheckBox.toolTipText"));
        this.antialiasingCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreeViewSettings.this.antialiasingCheckBoxActionPerformed(evt);
            }
        });
        this.boxesLabel.setFont(new Font("DejaVu Sans", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.boxesLabel, (String)NbBundle.getMessage(TreeViewSettings.class, (String)"TreeViewSettings.boxesLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.roundedRectanglesCheckBox, (String)NbBundle.getMessage(TreeViewSettings.class, (String)"TreeViewSettings.roundedRectanglesCheckBox.text"));
        this.roundedRectanglesCheckBox.setToolTipText(NbBundle.getMessage(TreeViewSettings.class, (String)"TreeViewSettings.roundedRectanglesCheckBox.toolTipText"));
        this.roundedRectanglesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreeViewSettings.this.roundedRectanglesCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.paddingLabel, (String)NbBundle.getMessage(TreeViewSettings.class, (String)"TreeViewSettings.paddingLabel.text"));
        this.paddingSpinner.setToolTipText(NbBundle.getMessage(TreeViewSettings.class, (String)"TreeViewSettings.paddingSpinner.toolTipText"));
        this.paddingSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TreeViewSettings.this.paddingSpinnerStateChanged(evt);
            }
        });
        this.indiLabel.setFont(new Font("DejaVu Sans", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.indiLabel, (String)NbBundle.getMessage(TreeViewSettings.class, (String)"TreeViewSettings.indiLabel.text"));
        this.famLabel.setFont(new Font("DejaVu Sans", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.famLabel, (String)NbBundle.getMessage(TreeViewSettings.class, (String)"TreeViewSettings.famLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.widthLabel, (String)NbBundle.getMessage(TreeViewSettings.class, (String)"TreeViewSettings.widthLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.heightLabel, (String)NbBundle.getMessage(TreeViewSettings.class, (String)"TreeViewSettings.heightLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.borderLabel, (String)NbBundle.getMessage(TreeViewSettings.class, (String)"TreeViewSettings.borderLabel.text"));
        this.wIndiSpinner.setToolTipText(NbBundle.getMessage(TreeViewSettings.class, (String)"TreeViewSettings.wIndiSpinner.toolTipText"));
        this.wIndiSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TreeViewSettings.this.wIndiSpinnerStateChanged(evt);
            }
        });
        this.hIndiSpinner.setToolTipText(NbBundle.getMessage(TreeViewSettings.class, (String)"TreeViewSettings.hIndiSpinner.toolTipText"));
        this.hIndiSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TreeViewSettings.this.hIndiSpinnerStateChanged(evt);
            }
        });
        this.bIndiSpinner.setToolTipText(NbBundle.getMessage(TreeViewSettings.class, (String)"TreeViewSettings.bIndiSpinner.toolTipText"));
        this.bIndiSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TreeViewSettings.this.bIndiSpinnerStateChanged(evt);
            }
        });
        this.wFamSpinner.setToolTipText(NbBundle.getMessage(TreeViewSettings.class, (String)"TreeViewSettings.wFamSpinner.toolTipText"));
        this.wFamSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TreeViewSettings.this.wFamSpinnerStateChanged(evt);
            }
        });
        this.hFamSpinner.setToolTipText(NbBundle.getMessage(TreeViewSettings.class, (String)"TreeViewSettings.hFamSpinner.toolTipText"));
        this.hFamSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TreeViewSettings.this.hFamSpinnerStateChanged(evt);
            }
        });
        this.bFamSpinner.setToolTipText(NbBundle.getMessage(TreeViewSettings.class, (String)"TreeViewSettings.bFamSpinner.toolTipText"));
        this.bFamSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TreeViewSettings.this.bFamSpinnerStateChanged(evt);
            }
        });
        GroupLayout tuningPanelLayout = new GroupLayout(this.tuningPanel);
        this.tuningPanel.setLayout(tuningPanelLayout);
        tuningPanelLayout.setHorizontalGroup(tuningPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tuningPanelLayout.createSequentialGroup().addContainerGap().addGroup(tuningPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tuningPanelLayout.createSequentialGroup().addGroup(tuningPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.fontChooser, -1, -1, Short.MAX_VALUE).addGroup(tuningPanelLayout.createSequentialGroup().addGroup(tuningPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fontLabel).addComponent(this.displayLabel).addGroup(tuningPanelLayout.createSequentialGroup().addGap(6, 6, 6).addGroup(tuningPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.marrsymbolsCheckBox).addComponent(this.bendCheckBox).addComponent(this.antialiasingCheckBox)))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()).addGroup(tuningPanelLayout.createSequentialGroup().addComponent(this.boxesLabel).addGap(138, 138, 138)).addGroup(tuningPanelLayout.createSequentialGroup().addGap(6, 6, 6).addGroup(tuningPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tuningPanelLayout.createSequentialGroup().addComponent(this.roundedRectanglesCheckBox).addGap(18, 18, 18).addComponent(this.paddingLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.paddingSpinner, -2, -1, -2)).addGroup(tuningPanelLayout.createSequentialGroup().addGroup(tuningPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.widthLabel).addComponent(this.heightLabel).addComponent(this.borderLabel)).addGap(48, 48, 48).addGroup(tuningPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.indiLabel).addComponent(this.wIndiSpinner).addComponent(this.hIndiSpinner).addComponent(this.bIndiSpinner)).addGap(18, 18, 18).addGroup(tuningPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.famLabel).addComponent(this.wFamSpinner).addComponent(this.hFamSpinner).addComponent(this.bFamSpinner)))).addGap(0, 114, Short.MAX_VALUE)))));
        tuningPanelLayout.setVerticalGroup(tuningPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tuningPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.fontLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.fontChooser, -2, -1, -2).addGap(18, 18, 18).addComponent(this.displayLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bendCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.marrsymbolsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.antialiasingCheckBox).addGap(18, 18, 18).addComponent(this.boxesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(tuningPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.roundedRectanglesCheckBox).addComponent(this.paddingLabel).addComponent(this.paddingSpinner, -2, 28, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(tuningPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.indiLabel).addComponent(this.famLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(tuningPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.widthLabel).addComponent(this.wIndiSpinner, -2, 28, -2).addComponent(this.wFamSpinner, -2, 28, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(tuningPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.heightLabel).addComponent(this.hIndiSpinner, -2, 28, -2).addComponent(this.hFamSpinner, -2, 28, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(tuningPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.borderLabel).addComponent(this.bIndiSpinner, -2, 28, -2).addComponent(this.bFamSpinner, -2, 28, -2)).addContainerGap()));
        this.jTabbedPane1.addTab(NbBundle.getMessage(TreeViewSettings.class, (String)"TreeViewSettings.tuningPanel.TabConstraints.tabTitle"), this.tuningPanel);
        this.jScrollPane1.setViewportView(this.jTabbedPane1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 428, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 451, Short.MAX_VALUE));
    }

    private void cbTreeAutoScrollActionPerformed(ActionEvent evt) {
        this.commit.actionPerformed(null);
    }

    private void jcActionActionPerformed(ActionEvent evt) {
        this.commit.actionPerformed(null);
    }

    private void spingenStateChanged(ChangeEvent evt) {
        this.commit.stateChanged(null);
    }

    private void cbShowPopupActionPerformed(ActionEvent evt) {
        this.commit.actionPerformed(null);
    }

    private void bListValueChanged(ListSelectionEvent evt) {
        int i = this.bList.getSelectedIndex();
        int n = this.bookmarks.getSize();
        this.upButton.setEnabled(i > 0);
        this.downButton.setEnabled(i >= 0 && i < n - 1);
        this.delButton.setEnabled(i >= 0);
    }

    private void upButtonActionPerformed(ActionEvent evt) {
        int i = this.bList.getSelectedIndex();
        this.bookmarks.swap(i, i - 1);
        this.bList.setSelectedIndex(i - 1);
        this.saveBookmarks();
    }

    private void downButtonActionPerformed(ActionEvent evt) {
        int i = this.bList.getSelectedIndex();
        this.bookmarks.swap(i, i + 1);
        this.bList.setSelectedIndex(i + 1);
        this.saveBookmarks();
    }

    private void delButtonActionPerformed(ActionEvent evt) {
        this.bookmarks.delete(this.bList.getSelectedIndex());
        this.saveBookmarks();
    }

    private void bendCheckBoxActionPerformed(ActionEvent evt) {
        this.commit.actionPerformed(new ActionEvent(evt.getSource(), 1, "settings"));
    }

    private void marrsymbolsCheckBoxActionPerformed(ActionEvent evt) {
        this.commit.actionPerformed(new ActionEvent(evt.getSource(), 1, "settings"));
    }

    private void antialiasingCheckBoxActionPerformed(ActionEvent evt) {
        this.commit.actionPerformed(new ActionEvent(evt.getSource(), 1, "settings"));
    }

    private void roundedRectanglesCheckBoxActionPerformed(ActionEvent evt) {
        this.commit.actionPerformed(new ActionEvent(evt.getSource(), 1, "settings"));
    }

    private void paddingSpinnerStateChanged(ChangeEvent evt) {
        this.commit.actionPerformed(new ActionEvent(evt.getSource(), 1, "settings"));
    }

    private void wIndiSpinnerStateChanged(ChangeEvent evt) {
        this.commit.actionPerformed(new ActionEvent(evt.getSource(), 1, "settings"));
    }

    private void wFamSpinnerStateChanged(ChangeEvent evt) {
        this.commit.actionPerformed(new ActionEvent(evt.getSource(), 1, "settings"));
    }

    private void hIndiSpinnerStateChanged(ChangeEvent evt) {
        this.commit.actionPerformed(new ActionEvent(evt.getSource(), 1, "settings"));
    }

    private void hFamSpinnerStateChanged(ChangeEvent evt) {
        this.commit.actionPerformed(new ActionEvent(evt.getSource(), 1, "settings"));
    }

    private void bIndiSpinnerStateChanged(ChangeEvent evt) {
        this.commit.actionPerformed(new ActionEvent(evt.getSource(), 1, "settings"));
    }

    private void bFamSpinnerStateChanged(ChangeEvent evt) {
        this.commit.actionPerformed(new ActionEvent(evt.getSource(), 1, "settings"));
    }

    private void stylesListValueChanged(ListSelectionEvent evt) {
        if (!this.busy) {
            this.commit.actionPerformed(new ActionEvent(evt.getSource(), 0, "style"));
        }
    }

    private void fontChooserStateChanged(ChangeEvent evt) {
        this.commit.actionPerformed(new ActionEvent(evt.getSource(), 1, "settings"));
    }

    private void separatorButtonActionPerformed(ActionEvent evt) {
        Object text = RESOURCES.getString("bookmark.name");
        String value = DialogManager.create((String)TreeView.TITLE, (String)(text = (String)text + " ".repeat(82).substring(((String)text).length())), (String)"").show();
        if (value == null) {
            return;
        }
        BookmarkSeparator newSeparator = new BookmarkSeparator(value);
        this.view.getModel().addBookmark(newSeparator);
        this.bookmarks.add(newSeparator);
        this.saveBookmarks();
    }

    private void jSpinnerDescStateChanged(ChangeEvent evt) {
        this.commit.stateChanged(null);
    }

    private void jCbHorizontalStyleActionPerformed(ActionEvent evt) {
        this.setStyleVisibility();
        this.jListHorizontalStyle.setEnabled(this.jCbHorizontalStyle.isSelected() && !this.view.getModel().isVertical());
        this.stylesList.setEnabled(!this.jCbHorizontalStyle.isSelected() || this.view.getModel().isVertical());
        this.commit.actionPerformed(null);
    }

    private void jListHorizontalStyleValueChanged(ListSelectionEvent evt) {
        if (!this.busy) {
            this.commit.actionPerformed(new ActionEvent(evt.getSource(), 0, "style"));
        }
    }

    private void setStyle(Style style) {
        this.busy = true;
        String prefix = "";
        if (this.jListHorizontalStyle.isEnabled()) {
            prefix = "h.";
        }
        this.colors.removeAllColors();
        for (String key : TreeStyleManager.ORDERCOLORS) {
            this.colors.addColor(key, RESOURCES.getString(prefix + "color." + key), style.colors.get(key));
        }
        this.fontChooser.setSelectedFont(style.font);
        this.bendCheckBox.setSelected(style.bend);
        this.marrsymbolsCheckBox.setSelected(style.marr);
        this.antialiasingCheckBox.setSelected(style.antialiasing);
        this.roundedRectanglesCheckBox.setSelected(style.roundrect);
        this.wIndiSpinner.setValue((double)style.tm.wIndis * 0.1);
        this.hIndiSpinner.setValue((double)style.tm.hIndis * 0.1);
        this.wFamSpinner.setValue((double)style.tm.wFams * 0.1);
        this.hFamSpinner.setValue((double)style.tm.hFams * 0.1);
        this.paddingSpinner.setValue((double)style.tm.pad * 0.1);
        this.bIndiSpinner.setValue(style.tm.indisThick);
        this.bFamSpinner.setValue(style.tm.famsThick);
        this.busy = false;
    }

    private void saveBookmarks() {
        Entity root = this.view.getModel().getRoot();
        if (root != null) {
            TreeView.REGISTRY.put(root.getGedcom().getName() + ".bookmarks", this.view.getModel().getBookmarks());
        }
    }

    private void setStyleVisibility() {
        boolean isVisible = this.jCbHorizontalStyle.isSelected();
        this.verticalLabel.setVisible(isVisible);
        this.horizontalLabel.setVisible(isVisible);
        this.jListHorizontalStyle.setVisible(isVisible);
    }

    public class Commit
    implements ChangeListener,
    ActionListener,
    ListDataListener {
        private final TreeView view;

        private Commit(TreeView view) {
            this.view = view;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (e != null && e.getSource() instanceof ColorsWidget) {
                this.actionPerformed(new ActionEvent(e.getSource(), 1, "settings"));
            } else {
                this.actionPerformed(null);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (TreeViewSettings.this.busy) {
                return;
            }
            if (e == null) {
                TreeView.setAutoScroll(TreeViewSettings.this.cbTreeAutoScroll.isSelected());
                TreeView.setOnAction((OnAction)((Object)TreeViewSettings.this.jcAction.getSelectedItem()));
                this.view.getModel().setMaxAscendants((Integer)TreeViewSettings.this.spingen.getValue());
                this.view.getModel().setMaxDescendants((Integer)TreeViewSettings.this.jSpinnerDesc.getValue());
                this.view.getModel().setUseHorizontalStyle(TreeViewSettings.this.jCbHorizontalStyle.isSelected());
                TreeView.setShowPopup(TreeViewSettings.this.cbShowPopup.isSelected());
                this.view.getModel().setStyle(TreeViewSettings.this.stylesList.isEnabled() ? TreeViewSettings.this.stylesList.getSelectedValue() : TreeViewSettings.this.jListHorizontalStyle.getSelectedValue());
                this.view.getModel().setBookmarks(TreeViewSettings.this.bookmarks.get());
                return;
            }
            if (e.getActionCommand().equals("style")) {
                Style newStyle;
                Style currentStyle = this.view.getStyle();
                Style style = newStyle = TreeViewSettings.this.stylesList.isEnabled() ? TreeViewSettings.this.stylesList.getSelectedValue() : TreeViewSettings.this.jListHorizontalStyle.getSelectedValue();
                if (newStyle != currentStyle && (currentStyle.key.equals("perso") || currentStyle.key.equals("perso_horizontal"))) {
                    this.view.saveStyle();
                }
                this.view.setStyle(newStyle);
                TreeViewSettings.this.setStyle(newStyle);
                return;
            }
            if (e.getActionCommand().equals("settings")) {
                if (!this.view.confirmStyleOverwrite()) {
                    return;
                }
                Style persoStyle = this.view.getStyleManager().getPersoStyle(TreeViewSettings.this.jListHorizontalStyle.isEnabled());
                persoStyle.blueprintIndi = this.view.getModel().getStyle().blueprintIndi;
                persoStyle.blueprintFam = this.view.getModel().getStyle().blueprintFam;
                this.view.setStyle(persoStyle);
                TreeViewSettings.this.busy = true;
                TreeViewSettings.this.stylesList.setSelectedIndex(0);
                TreeViewSettings.this.busy = false;
                this.view.setColors(TreeViewSettings.this.colors.getColors());
                this.view.setContentFont(TreeViewSettings.this.fontChooser.getSelectedFont());
                this.view.getModel().setBendArcs(TreeViewSettings.this.bendCheckBox.isSelected());
                this.view.getModel().setMarrSymbols(TreeViewSettings.this.marrsymbolsCheckBox.isSelected());
                this.view.setAntialiasing(TreeViewSettings.this.antialiasingCheckBox.isSelected());
                this.view.getModel().setRoundedRectangle(TreeViewSettings.this.roundedRectanglesCheckBox.isSelected());
                this.view.getModel().setMetrics(new TreeMetrics((int)((Double)TreeViewSettings.this.wIndiSpinner.getModel().getValue() * 10.0), (int)((Double)TreeViewSettings.this.hIndiSpinner.getModel().getValue() * 10.0), (int)((Double)TreeViewSettings.this.wFamSpinner.getModel().getValue() * 10.0), (int)((Double)TreeViewSettings.this.hFamSpinner.getModel().getValue() * 10.0), (int)((Double)TreeViewSettings.this.paddingSpinner.getModel().getValue() * 10.0), (Integer)TreeViewSettings.this.bIndiSpinner.getModel().getValue(), (Integer)TreeViewSettings.this.bFamSpinner.getModel().getValue()));
            }
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            this.actionPerformed(null);
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            this.actionPerformed(null);
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            this.actionPerformed(null);
        }
    }

    private class Styles
    extends AbstractListModel<Style> {
        private final ArrayList<Style> list;

        Styles(Collection<Style> list) {
            this.list = new ArrayList<Style>(list);
        }

        @Override
        public Style getElementAt(int index) {
            return this.list.get(index);
        }

        @Override
        public int getSize() {
            return this.list.size();
        }

        public List<Style> get() {
            return Collections.unmodifiableList(this.list);
        }
    }

    private class Bookmarks
    extends AbstractListModel<String> {
        private final ArrayList<Bookmark> list;

        Bookmarks(List<Bookmark> list) {
            this.list = new ArrayList<Bookmark>(list);
        }

        @Override
        public String getElementAt(int index) {
            return this.list.get(index).getName();
        }

        @Override
        public int getSize() {
            return this.list.size();
        }

        public void swap(int i, int j) {
            if (i == j) {
                return;
            }
            Bookmark b = this.list.get(i);
            this.list.set(i, this.list.get(j));
            this.list.set(j, b);
            this.fireContentsChanged(this, Math.min(i, j), Math.max(i, j));
        }

        public void delete(int i) {
            this.list.remove(i);
            this.fireIntervalRemoved(this, i, i);
        }

        public void add(Bookmark b) {
            this.list.add(b);
            this.fireIntervalAdded(this, 0, 1);
        }

        public List<Bookmark> get() {
            return Collections.unmodifiableList(this.list);
        }
    }

    public static enum OnAction {
        NONE("tv.action.none"),
        CENTER("tv.action.center"),
        SETROOT("tv.action.setroot");

        private final String description;

        private OnAction(String desc) {
            this.description = RESOURCES.getString(desc);
        }

        public String toString() {
            return this.description + "     ";
        }
    }

    private static class ListEntryCellRenderer
    extends JLabel
    implements ListCellRenderer<Style> {
        private ListEntryCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Style> list, Style style, int index, boolean isSelected, boolean cellHasFocus) {
            this.setHorizontalTextPosition(0);
            this.setVerticalTextPosition(3);
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(1);
            this.setPreferredSize(new Dimension(120, 105));
            this.setIcon((Icon)style.icon);
            this.setText(style.name);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createRaisedBevelBorder()));
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }
}

