/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm;

import java.util.LinkedList;
import java.util.StringJoiner;
import org.graphstream.algorithm.Kruskal;
import org.graphstream.algorithm.util.FibonacciHeap;
import org.graphstream.algorithm.util.Result;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Node;

public class Prim
extends Kruskal {
    public Prim() {
    }

    public Prim(String weightAttribute, String flagAttribute) {
        super(weightAttribute, flagAttribute);
    }

    public Prim(String flagAttribute, Object flagOn, Object flagOff) {
        super(flagAttribute, flagOn, flagOff);
    }

    public Prim(String weightAttribute, String flagAttribute, Object flagOn, Object flagOff) {
        super(weightAttribute, flagAttribute, flagOn, flagOff);
    }

    @Override
    protected void makeTree() {
        if (this.treeEdges == null) {
            this.treeEdges = new LinkedList();
        } else {
            this.treeEdges.clear();
        }
        int n = this.graph.getNodeCount();
        Data[] data = new Data[n];
        FibonacciHeap<Double, Node> heap = new FibonacciHeap<Double, Node>();
        for (int i = 0; i < n; ++i) {
            data[i] = new Data();
            data[i].edgeToTree = null;
            data[i].fn = heap.add(Double.POSITIVE_INFINITY, this.graph.getNode(i));
        }
        this.treeWeight = 0.0;
        while (!heap.isEmpty()) {
            Node u = (Node)heap.extractMin();
            Data dataU = data[u.getIndex()];
            data[u.getIndex()] = null;
            if (dataU.edgeToTree != null) {
                this.treeEdges.add(dataU.edgeToTree);
                this.edgeOn(dataU.edgeToTree);
                this.treeWeight += ((Double)dataU.fn.getKey()).doubleValue();
                dataU.edgeToTree = null;
            }
            dataU.fn = null;
            u.edges().filter(e -> data[e.getOpposite(u).getIndex()] != null).forEach(e -> {
                Node v = e.getOpposite(u);
                Data dataV = data[v.getIndex()];
                double w = this.getWeight((Edge)e);
                if (w < (Double)dataV.fn.getKey()) {
                    heap.decreaseKey(dataV.fn, w);
                    dataV.edgeToTree = e;
                }
            });
        }
    }

    @Override
    @Result
    public String defaultResult() {
        StringJoiner sj = new StringJoiner(" | ", "====== Prim ====== \n", "");
        this.getTreeEdgesStream().forEach(n -> sj.add(n.getId()));
        return sj.toString();
    }

    protected static class Data {
        Edge edgeToTree;
        FibonacciHeap.Node fn;

        protected Data() {
        }
    }
}

