/*
 * Decompiled with CFR 0.152.
 */
package org.oxbow.swingbits.table.filter;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.oxbow.swingbits.table.filter.DistinctColumnItem;
import org.oxbow.swingbits.table.filter.ITableFilter;
import org.oxbow.swingbits.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TableFilterState
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<Integer, Set<DistinctColumnItem>> data = new HashMap<Integer, Set<DistinctColumnItem>>();

    TableFilterState() {
    }

    public void clear(int n) {
        this.data.remove(n);
    }

    public void clear() {
        this.data.clear();
    }

    private Set<DistinctColumnItem> prepareValueSet(int n) {
        Set<DistinctColumnItem> set = this.data.get(n);
        if (set == null) {
            set = new HashSet<DistinctColumnItem>();
            this.data.put(n, set);
        }
        return set;
    }

    public void addValue(int n, DistinctColumnItem distinctColumnItem) {
        this.prepareValueSet(n).add(distinctColumnItem);
    }

    public void addValues(int n, Collection<DistinctColumnItem> collection) {
        this.prepareValueSet(n).addAll(collection);
    }

    public void setValues(int n, Collection<DistinctColumnItem> collection) {
        this.data.remove(n);
        if (!CollectionUtils.isEmpty(collection)) {
            this.prepareValueSet(n).addAll(collection);
        }
    }

    public Collection<DistinctColumnItem> getValues(int n) {
        Set<DistinctColumnItem> set = this.data.get(n);
        return set == null ? Collections.emptySet() : set;
    }

    public boolean include(ITableFilter.Row row) {
        for (int i = 0; i < row.getValueCount(); ++i) {
            Collection<DistinctColumnItem> collection = this.getValues(i);
            if (CollectionUtils.isEmpty(collection) || collection.contains(new DistinctColumnItem(row.getValue(i), 0))) continue;
            return false;
        }
        return true;
    }
}

