/*
 * Decompiled with CFR 0.152.
 */
package org.oxbow.swingbits.util.swing;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public class CompoundIcon
implements Icon {
    public static final float TOP = 0.0f;
    public static final float LEFT = 0.0f;
    public static final float CENTER = 0.5f;
    public static final float BOTTOM = 1.0f;
    public static final float RIGHT = 1.0f;
    private Icon[] icons;
    private Layout layout;
    private int gap;
    private float alignmentX = 0.5f;
    private float alignmentY = 0.5f;

    public CompoundIcon(Icon ... iconArray) {
        this(Layout.HORIZONTAL, iconArray);
    }

    public CompoundIcon(Layout layout, Icon ... iconArray) {
        this(layout, 0, iconArray);
    }

    public CompoundIcon(Layout layout, int n, Icon ... iconArray) {
        this(layout, n, 0.5f, 0.5f, iconArray);
    }

    public CompoundIcon(Layout layout, int n, float f, float f2, Icon ... iconArray) {
        this.layout = layout;
        this.gap = n;
        float f3 = f > 1.0f ? 1.0f : (this.alignmentX = f < 0.0f ? 0.0f : f);
        this.alignmentY = f2 > 1.0f ? 1.0f : (f2 < 0.0f ? 0.0f : f2);
        for (int i = 0; i < iconArray.length; ++i) {
            if (iconArray[i] != null) continue;
            throw new IllegalArgumentException("Icon (" + i + ") cannot be null");
        }
        this.icons = iconArray;
    }

    public Layout getLayout() {
        return this.layout;
    }

    public int getGap() {
        return this.gap;
    }

    public float getAlignmentX() {
        return this.alignmentX;
    }

    public float getAlignmentY() {
        return this.alignmentY;
    }

    public int getIconCount() {
        return this.icons.length;
    }

    public Icon getIcon(int n) {
        return this.icons[n];
    }

    public int getIconWidth() {
        int n = 0;
        if (this.layout == Layout.HORIZONTAL) {
            n += (this.icons.length - 1) * this.gap;
            for (Icon icon : this.icons) {
                n += icon.getIconWidth();
            }
        } else {
            for (Icon icon : this.icons) {
                n = Math.max(n, icon.getIconWidth());
            }
        }
        return n;
    }

    public int getIconHeight() {
        int n = 0;
        if (this.layout == Layout.VERTICAL) {
            n += (this.icons.length - 1) * this.gap;
            for (Icon icon : this.icons) {
                n += icon.getIconHeight();
            }
        } else {
            for (Icon icon : this.icons) {
                n = Math.max(n, icon.getIconHeight());
            }
        }
        return n;
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        if (this.layout == Layout.HORIZONTAL) {
            int n3 = this.getIconHeight();
            for (Icon icon : this.icons) {
                int n4 = this.getOffset(n3, icon.getIconHeight(), this.alignmentY);
                icon.paintIcon(component, graphics, n, n2 + n4);
                n += icon.getIconWidth() + this.gap;
            }
        } else if (this.layout == Layout.VERTICAL) {
            int n5 = this.getIconWidth();
            for (Icon icon : this.icons) {
                int n6 = this.getOffset(n5, icon.getIconWidth(), this.alignmentX);
                icon.paintIcon(component, graphics, n + n6, n2);
                n2 += icon.getIconHeight() + this.gap;
            }
        } else {
            int n7 = this.getIconWidth();
            int n8 = this.getIconHeight();
            for (Icon icon : this.icons) {
                int n9 = this.getOffset(n7, icon.getIconWidth(), this.alignmentX);
                int n10 = this.getOffset(n8, icon.getIconHeight(), this.alignmentY);
                icon.paintIcon(component, graphics, n + n9, n2 + n10);
            }
        }
    }

    private int getOffset(int n, int n2, float f) {
        float f2 = (float)(n - n2) * f;
        return Math.round(f2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Layout {
        HORIZONTAL,
        VERTICAL,
        STACKED;

    }
}

