require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_BITS_CPU_SET_H)) {
    eval 'sub _BITS_CPU_SET_H () {1;}' unless defined(&_BITS_CPU_SET_H);
    unless(defined(&_SCHED_H)) {
	die("Never include <bits/cpu-set.h> directly; use <sched.h> instead.");
    }
    eval 'sub __CPU_SETSIZE () {1024;}' unless defined(&__CPU_SETSIZE);
    eval 'sub __NCPUBITS () {(8* $sizeof{ &__cpu_mask});}' unless defined(&__NCPUBITS);
    eval 'sub __CPUELT {
        my($cpu) = @_;
	    eval q((($cpu) /  &__NCPUBITS));
    }' unless defined(&__CPUELT);
    eval 'sub __CPUMASK {
        my($cpu) = @_;
	    eval q((( &__cpu_mask) 1<< (($cpu) %  &__NCPUBITS)));
    }' unless defined(&__CPUMASK);
    if( &__GNUC_PREREQ (2, 91)) {
	eval 'sub __CPU_ZERO_S {
	    my($setsize, $cpusetp) = @_;
    	    eval q( &do  &__builtin_memset ($cpusetp, ord(\'\\\\0\'), $setsize);  &while (0));
	}' unless defined(&__CPU_ZERO_S);
    } else {
	eval 'sub __CPU_ZERO_S {
	    my($setsize, $cpusetp) = @_;
    	    eval q( &do { \'size_t\'  &__i; \'size_t\'  &__imax = ($setsize) / $sizeof{ &__cpu_mask};  &__cpu_mask * &__bits = ($cpusetp)-> &__bits;  &for ( &__i = 0;  &__i <  &__imax; ++ &__i)  $__bits[ &__i] = 0; }  &while (0));
	}' unless defined(&__CPU_ZERO_S);
    }
    eval 'sub __CPU_SET_S {
        my($cpu, $setsize, $cpusetp) = @_;
	    eval q(( &__extension__ ({ \'size_t\'  &__cpu = ($cpu);  &__cpu / 8< ($setsize) ? ((( &__cpu_mask *) (($cpusetp)-> &__bits))[ &__CPUELT ( &__cpu)] |=  &__CPUMASK ( &__cpu)) : 0; })));
    }' unless defined(&__CPU_SET_S);
    eval 'sub __CPU_CLR_S {
        my($cpu, $setsize, $cpusetp) = @_;
	    eval q(( &__extension__ ({ \'size_t\'  &__cpu = ($cpu);  &__cpu / 8< ($setsize) ? ((( &__cpu_mask *) (($cpusetp)-> &__bits))[ &__CPUELT ( &__cpu)] &= ~ &__CPUMASK ( &__cpu)) : 0; })));
    }' unless defined(&__CPU_CLR_S);
    eval 'sub __CPU_ISSET_S {
        my($cpu, $setsize, $cpusetp) = @_;
	    eval q(( &__extension__ ({ \'size_t\'  &__cpu = ($cpu);  &__cpu / 8< ($setsize) ? (((( &const  &__cpu_mask *) (($cpusetp)-> &__bits))[ &__CPUELT ( &__cpu)] &  &__CPUMASK ( &__cpu))) != 0: 0; })));
    }' unless defined(&__CPU_ISSET_S);
    eval 'sub __CPU_COUNT_S {
        my($setsize, $cpusetp) = @_;
	    eval q( &__sched_cpucount ($setsize, $cpusetp));
    }' unless defined(&__CPU_COUNT_S);
    if( &__GNUC_PREREQ (2, 91)) {
	eval 'sub __CPU_EQUAL_S {
	    my($setsize, $cpusetp1, $cpusetp2) = @_;
    	    eval q(( &__builtin_memcmp ($cpusetp1, $cpusetp2, $setsize) == 0));
	}' unless defined(&__CPU_EQUAL_S);
    } else {
	eval 'sub __CPU_EQUAL_S {
	    my($setsize, $cpusetp1, $cpusetp2) = @_;
    	    eval q(( &__extension__ ({  &const  &__cpu_mask * &__arr1 = ($cpusetp1)-> &__bits;  &const  &__cpu_mask * &__arr2 = ($cpusetp2)-> &__bits; \'size_t\'  &__imax = ($setsize) / $sizeof{ &__cpu_mask}; \'size_t\'  &__i;  &for ( &__i = 0;  &__i <  &__imax; ++ &__i)  &if ( $__arr1[ &__i] !=  $__arr2[ &__i])  &break;  &__i ==  &__imax; })));
	}' unless defined(&__CPU_EQUAL_S);
    }
    eval 'sub __CPU_OP_S {
        my($setsize, $destset, $srcset1, $srcset2, $op) = @_;
	    eval q(( &__extension__ ({  &cpu_set_t * &__dest = ($destset);  &const  &__cpu_mask * &__arr1 = ($srcset1)-> &__bits;  &const  &__cpu_mask * &__arr2 = ($srcset2)-> &__bits; \'size_t\'  &__imax = ($setsize) / $sizeof{ &__cpu_mask}; \'size_t\'  &__i;  &for ( &__i = 0;  &__i <  &__imax; ++ &__i) (( &__cpu_mask *)  ($__dest->{__bits}))[ &__i] =  $__arr1[ &__i] $op  $__arr2[ &__i];  &__dest; })));
    }' unless defined(&__CPU_OP_S);
    eval 'sub __CPU_ALLOC_SIZE {
        my($count) = @_;
	    eval q((((($count) +  &__NCPUBITS - 1) /  &__NCPUBITS) * $sizeof{ &__cpu_mask}));
    }' unless defined(&__CPU_ALLOC_SIZE);
    eval 'sub __CPU_ALLOC {
        my($count) = @_;
	    eval q( &__sched_cpualloc ($count));
    }' unless defined(&__CPU_ALLOC);
    eval 'sub __CPU_FREE {
        my($cpuset) = @_;
	    eval q( &__sched_cpufree ($cpuset));
    }' unless defined(&__CPU_FREE);
}
1;
