/*
 * Decompiled with CFR 0.152.
 */
package vlcskineditor.items;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Node;
import vlcskineditor.Bezier;
import vlcskineditor.Helper;
import vlcskineditor.Item;
import vlcskineditor.Language;
import vlcskineditor.Main;
import vlcskineditor.NumbersOnlyDocument;
import vlcskineditor.Skin;
import vlcskineditor.XML;
import vlcskineditor.history.AnchorEditEvent;
import vlcskineditor.history.ItemAddEvent;

public class Anchor
extends Item
implements ActionListener {
    public final String POINTS_DEFAULT = "(0,0)";
    public final int RANGE_DEFAULT = 10;
    public int priority;
    public String points = "(0,0)";
    public int range = 10;
    JFrame frame = null;
    JTextField id_tf;
    JTextField x_tf;
    JTextField y_tf;
    JTextField points_tf;
    JTextField range_tf;
    JTextField priority_tf;
    JComboBox lefttop_cb;
    JButton ok_btn;
    JButton cancel_btn;
    JButton help_btn;
    Bezier b;
    int[] xpos;
    int[] ypos;

    public Anchor(Node node, Skin skin) {
        this.type = Language.get("ANCHOR");
        this.s = skin;
        this.id = XML.getStringAttributeValue(node, "id", Language.get("UNNAMED").replaceAll("%t", this.type).replaceAll("%i", String.valueOf(this.s.getNewId())));
        this.points = XML.getStringAttributeValue(node, "points", this.points);
        this.priority = XML.getIntAttributeValue(node, "priority", this.priority);
        this.range = XML.getIntAttributeValue(node, "range", this.range);
        this.x = XML.getIntAttributeValue(node, "x", this.x);
        this.y = XML.getIntAttributeValue(node, "y", this.y);
        this.lefttop = XML.getStringAttributeValue(node, "lefttop", this.lefttop);
        this.updateBezier();
        this.created = true;
    }

    public Anchor(String string, Skin skin) {
        this.type = Language.get("ANCHOR");
        this.s = skin;
        if (string.indexOf(" points=\"") != -1) {
            this.points = XML.getValue(string, "points");
        }
        this.updateBezier();
        this.priority = XML.getIntValue(string, "priority");
        if (string.indexOf(" range=\"") != -1) {
            this.range = XML.getIntValue(string, "range");
        }
        if (string.indexOf(" x=\"") != -1) {
            this.x = XML.getIntValue(string, "x");
        }
        if (string.indexOf(" y=\"") != -1) {
            this.y = XML.getIntValue(string, "y");
        }
        this.id = string.indexOf(" id=\"") != -1 ? XML.getValue(string, "id") : this.type + " #" + this.s.getNewId();
        if (string.indexOf("lefttop=\"") != -1) {
            this.lefttop = XML.getValue(string, "lefttop");
        }
        this.created = true;
    }

    public Anchor(Skin skin) {
        this.type = Language.get("ANCHOR");
        this.s = skin;
        this.priority = 0;
        this.id = this.type + " #" + this.s.getNewId();
        this.updateBezier();
        this.showOptions();
    }

    public void updateBezier() {
        String[] stringArray = this.points.split("\\),\\(");
        this.xpos = new int[stringArray.length];
        this.ypos = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String[] stringArray2 = string.split(",");
            this.xpos[i] = Integer.parseInt(stringArray2[0].replaceAll("\\(", ""));
            this.ypos[i] = Integer.parseInt(stringArray2[1].replaceAll("\\)", ""));
        }
        this.b = new Bezier(this.xpos, this.ypos, 0);
    }

    @Override
    public void update() {
        if (!this.created) {
            this.id = this.id_tf.getText();
            this.priority = Integer.parseInt(this.priority_tf.getText());
            this.lefttop = this.lefttop_cb.getSelectedItem().toString();
            this.x = Integer.parseInt(this.x_tf.getText());
            this.y = Integer.parseInt(this.y_tf.getText());
            this.points = this.points_tf.getText();
            this.range = Integer.parseInt(this.range_tf.getText());
            this.updateBezier();
            this.s.updateItems();
            this.s.expandItem(this.id);
            this.frame.setDefaultCloseOperation(2);
            this.created = true;
            ItemAddEvent itemAddEvent = new ItemAddEvent(this.s.getParentListOf(this.id), this);
            this.s.m.hist.addEvent(itemAddEvent);
        } else {
            AnchorEditEvent anchorEditEvent = new AnchorEditEvent(this);
            this.id = this.id_tf.getText();
            this.priority = Integer.parseInt(this.priority_tf.getText());
            this.lefttop = this.lefttop_cb.getSelectedItem().toString();
            this.x = Integer.parseInt(this.x_tf.getText());
            this.y = Integer.parseInt(this.y_tf.getText());
            this.points = this.points_tf.getText();
            this.range = Integer.parseInt(this.range_tf.getText());
            this.updateBezier();
            this.s.updateItems();
            this.s.expandItem(this.id);
            anchorEditEvent.setNew();
            this.s.m.hist.addEvent(anchorEditEvent);
        }
    }

    @Override
    public void showOptions() {
        if (this.frame == null) {
            this.frame = new JFrame(Language.get("WIN_ANCHOR_TITLE"));
            this.frame.setIconImage(Main.edit_icon.getImage());
            this.frame.setResizable(false);
            if (!this.created) {
                this.frame.setDefaultCloseOperation(0);
            }
            JLabel jLabel = new JLabel(Language.get("WIN_ITEM_ID"));
            this.id_tf = new JTextField();
            JLabel jLabel2 = new JLabel(Language.get("WIN_ITEM_X"));
            this.x_tf = new JTextField();
            this.x_tf.setDocument(new NumbersOnlyDocument());
            JLabel jLabel3 = new JLabel(Language.get("WIN_ITEM_Y"));
            this.y_tf = new JTextField();
            this.y_tf.setDocument(new NumbersOnlyDocument());
            JLabel jLabel4 = new JLabel(Language.get("WIN_ANCHOR_POINTS"));
            this.points_tf = new JTextField();
            this.points_tf.setToolTipText(Language.get("WIN_ANCHOR_POINTS_TIP"));
            JLabel jLabel5 = new JLabel(Language.get("WIN_ANCHOR_RANGE"));
            this.range_tf = new JTextField();
            this.range_tf.setToolTipText(Language.get("WIN_ANCHOR_RANGE_TIP"));
            this.range_tf.setDocument(new NumbersOnlyDocument());
            JLabel jLabel6 = new JLabel(Language.get("WIN_ANCHOR_PRIORITY"));
            this.priority_tf = new JTextField();
            this.priority_tf.setToolTipText(Language.get("WIN_ANCHOR_PRIORITY_TIP"));
            this.priority_tf.setDocument(new NumbersOnlyDocument());
            JLabel jLabel7 = new JLabel(Language.get("WIN_ITEM_LEFTTOP"));
            String[] stringArray = new String[]{"lefttop", "leftbottom", "righttop", "rightbottom"};
            this.lefttop_cb = new JComboBox<String>(stringArray);
            this.lefttop_cb.setToolTipText(Language.get("WIN_ITEM_LEFTTOP_TIP"));
            this.ok_btn = new JButton(Language.get("BUTTON_OK"));
            this.ok_btn.addActionListener(this);
            this.cancel_btn = new JButton(Language.get("BUTTON_CANCEL"));
            this.cancel_btn.addActionListener(this);
            this.help_btn = new JButton(Language.get("BUTTON_HELP"));
            this.help_btn.addActionListener(this);
            JLabel jLabel8 = new JLabel(Language.get("NOTE_STARRED"));
            Component[] componentArray = new Component[]{jLabel, jLabel6, jLabel7, jLabel2, jLabel3, jLabel5, jLabel4};
            int n = Helper.maxWidth(componentArray) + 10;
            int n2 = 200;
            JPanel jPanel = new JPanel();
            jPanel.add(jLabel);
            this.id_tf.setPreferredSize(new Dimension(n2, this.id_tf.getPreferredSize().height));
            jPanel.add(this.id_tf);
            jPanel.add(jLabel6);
            jPanel.add(this.priority_tf);
            jPanel.add(jLabel7);
            jPanel.add(this.lefttop_cb);
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Language.get("WIN_ITEM_GENERAL")));
            SpringLayout springLayout = new SpringLayout();
            springLayout.putConstraint("North", (Component)jLabel, 5, "North", (Component)jPanel);
            springLayout.putConstraint("West", (Component)jLabel, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.id_tf, 0, "VerticalCenter", (Component)jLabel);
            springLayout.putConstraint("West", (Component)this.id_tf, n, "West", (Component)jPanel);
            springLayout.putConstraint("North", (Component)jLabel6, 10, "South", (Component)this.id_tf);
            springLayout.putConstraint("West", (Component)jLabel6, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.priority_tf, 0, "VerticalCenter", (Component)jLabel6);
            springLayout.putConstraint("West", (Component)this.priority_tf, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.priority_tf, 0, "East", (Component)this.id_tf);
            springLayout.putConstraint("North", (Component)jLabel7, 10, "South", (Component)this.priority_tf);
            springLayout.putConstraint("West", (Component)jLabel7, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.lefttop_cb, 0, "VerticalCenter", (Component)jLabel7);
            springLayout.putConstraint("West", (Component)this.lefttop_cb, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.lefttop_cb, 0, "East", (Component)this.id_tf);
            springLayout.putConstraint("East", (Component)jPanel, 5, "East", (Component)this.id_tf);
            springLayout.putConstraint("South", (Component)jPanel, 10, "South", (Component)this.lefttop_cb);
            jPanel.setLayout(springLayout);
            this.frame.add(jPanel);
            JPanel jPanel2 = new JPanel();
            jPanel2.add(jLabel2);
            this.x_tf.setPreferredSize(new Dimension(n2, this.x_tf.getPreferredSize().height));
            jPanel2.add(this.x_tf);
            jPanel2.add(jLabel3);
            jPanel2.add(this.y_tf);
            jPanel2.add(jLabel4);
            jPanel2.add(this.points_tf);
            jPanel2.add(jLabel5);
            jPanel2.add(this.range_tf);
            jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Language.get("WIN_ANCHOR_BOUNDARIES")));
            SpringLayout springLayout2 = new SpringLayout();
            springLayout2.putConstraint("North", (Component)jLabel2, 5, "North", (Component)jPanel2);
            springLayout2.putConstraint("West", (Component)jLabel2, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.id_tf, 0, "VerticalCenter", (Component)jLabel2);
            springLayout2.putConstraint("West", (Component)this.x_tf, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("North", (Component)jLabel3, 10, "South", (Component)this.x_tf);
            springLayout2.putConstraint("West", (Component)jLabel3, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.y_tf, 0, "VerticalCenter", (Component)jLabel3);
            springLayout2.putConstraint("West", (Component)this.y_tf, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("East", (Component)this.y_tf, 0, "East", (Component)this.x_tf);
            springLayout2.putConstraint("North", (Component)jLabel4, 10, "South", (Component)this.y_tf);
            springLayout2.putConstraint("West", (Component)jLabel4, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.points_tf, 0, "VerticalCenter", (Component)jLabel4);
            springLayout2.putConstraint("West", (Component)this.points_tf, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("East", (Component)this.points_tf, 0, "East", (Component)this.x_tf);
            springLayout2.putConstraint("North", (Component)jLabel5, 10, "South", (Component)this.points_tf);
            springLayout2.putConstraint("West", (Component)jLabel5, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.range_tf, 0, "VerticalCenter", (Component)jLabel5);
            springLayout2.putConstraint("West", (Component)this.range_tf, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("East", (Component)this.range_tf, 0, "East", (Component)this.x_tf);
            springLayout2.putConstraint("East", (Component)jPanel2, 5, "East", (Component)this.x_tf);
            springLayout2.putConstraint("South", (Component)jPanel2, 10, "South", (Component)this.range_tf);
            jPanel2.setLayout(springLayout2);
            this.frame.add(jPanel2);
            this.frame.add(jLabel8);
            this.frame.add(this.ok_btn);
            this.frame.add(this.cancel_btn);
            this.frame.add(this.help_btn);
            SpringLayout springLayout3 = new SpringLayout();
            springLayout3.putConstraint("North", (Component)jPanel, 5, "North", (Component)this.frame.getContentPane());
            springLayout3.putConstraint("West", (Component)jPanel, 5, "West", (Component)this.frame.getContentPane());
            springLayout3.putConstraint("North", (Component)jPanel2, 10, "South", (Component)jPanel);
            springLayout3.putConstraint("West", (Component)jPanel2, 5, "West", (Component)this.frame.getContentPane());
            springLayout3.putConstraint("North", (Component)jLabel8, 10, "South", (Component)jPanel2);
            springLayout3.putConstraint("West", (Component)jLabel8, 5, "West", (Component)this.frame.getContentPane());
            springLayout3.putConstraint("North", (Component)this.ok_btn, 10, "South", (Component)jLabel8);
            springLayout3.putConstraint("West", (Component)this.ok_btn, 5, "West", (Component)this.frame.getContentPane());
            springLayout3.putConstraint("North", (Component)this.cancel_btn, 0, "North", (Component)this.ok_btn);
            springLayout3.putConstraint("West", (Component)this.cancel_btn, 5, "East", (Component)this.ok_btn);
            springLayout3.putConstraint("North", (Component)this.help_btn, 0, "North", (Component)this.cancel_btn);
            springLayout3.putConstraint("West", (Component)this.help_btn, 5, "East", (Component)this.cancel_btn);
            springLayout3.putConstraint("South", (Component)this.frame.getContentPane(), 10, "South", (Component)this.ok_btn);
            springLayout3.putConstraint("East", (Component)this.frame.getContentPane(), 5, "East", (Component)jPanel);
            this.frame.setLayout(springLayout3);
            this.frame.pack();
            this.frame.getRootPane().setDefaultButton(this.ok_btn);
        }
        this.id_tf.setText(this.id);
        this.priority_tf.setText(String.valueOf(this.priority));
        this.lefttop_cb.setSelectedItem(this.lefttop);
        this.x_tf.setText(String.valueOf(this.x));
        this.y_tf.setText(String.valueOf(this.y));
        this.points_tf.setText(this.points);
        this.range_tf.setText(String.valueOf(this.range));
        this.frame.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.ok_btn)) {
            if (this.id_tf.getText().equals("")) {
                JOptionPane.showMessageDialog(this.frame, Language.get("ERROR_ID_INVALID_MSG"), Language.get("ERROR_ID_INVALID_TITLE"), 1);
                return;
            }
            if (!this.id_tf.getText().equals(this.id) && this.s.idExists(this.id_tf.getText())) {
                JOptionPane.showMessageDialog(this.frame, Language.get("ERROR_ID_EXISTS_MSG").replaceAll("%i", this.id_tf.getText()), Language.get("ERROR_ID_INVALID_TITLE"), 1);
                return;
            }
            this.update();
            this.frame.setVisible(false);
            this.frame.dispose();
            this.frame = null;
        } else if (actionEvent.getSource().equals(this.help_btn)) {
            Helper.browse("http://www.videolan.org/vlc/skinedhlp/i-anchor.html");
        } else if (actionEvent.getSource().equals(this.cancel_btn)) {
            List<Item> list;
            if (!this.created && (list = this.s.getParentListOf(this.id)) != null) {
                list.remove(this);
            }
            this.frame.setVisible(false);
            this.frame.dispose();
            this.frame = null;
        }
    }

    @Override
    public String returnCode(String string) {
        String string2 = string + "<Anchor";
        if (!this.id.equals("Unnamed")) {
            string2 = string2 + " id=\"" + this.id + "\"";
        }
        if (this.x != 0) {
            string2 = string2 + " x=\"" + String.valueOf(this.x) + "\"";
        }
        if (this.y != 0) {
            string2 = string2 + " y=\"" + String.valueOf(this.y) + "\"";
        }
        if (!this.points.equals("(0,0)")) {
            string2 = string2 + " points=\"" + this.points + "\"";
        }
        string2 = string2 + " priority=\"" + String.valueOf(this.priority) + "\"";
        if (!this.lefttop.equals("lefttop")) {
            string2 = string2 + " lefttop=\"" + this.lefttop + "\"";
        }
        string2 = string2 + "/>";
        return string2;
    }

    @Override
    public void draw(Graphics2D graphics2D, int n) {
        this.draw(graphics2D, this.offsetx, this.offsety, n);
    }

    @Override
    public void draw(Graphics2D graphics2D, int n, int n2, int n3) {
        if (!this.created) {
            return;
        }
        if (this.selected) {
            graphics2D.setColor(Color.RED);
            for (float f = 0.0f; f <= 1.0f; f += 0.1f) {
                Point2D.Float float_ = this.b.getPoint(f);
                Point2D.Float float_2 = this.b.getPoint(f + 0.1f);
                graphics2D.drawLine((int)(float_.getX() + (double)this.x + (double)n) * n3, (int)(float_.getY() + (double)this.y + (double)n2) * n3, (int)(float_2.getX() + (double)this.x + (double)n) * n3, (int)(float_2.getY() + (double)this.y + (double)n2) * n3);
            }
            graphics2D.setColor(Color.YELLOW);
            for (int i = 0; i < this.xpos.length; ++i) {
                graphics2D.fillOval((this.xpos[i] + this.x + n - 1) * n3, (this.ypos[i] + this.y + n2 - 1) * n3, 3, 3);
            }
        }
    }

    @Override
    public boolean contains(int n, int n2) {
        return true;
    }

    @Override
    public DefaultMutableTreeNode getTreeNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Anchor: " + this.id);
        return defaultMutableTreeNode;
    }
}

