/*
 * Decompiled with CFR 0.152.
 */
package vlcskineditor;

import java.awt.Component;
import java.awt.Desktop;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JOptionPane;
import vlcskineditor.Language;

public class Helper {
    private static Desktop desktop;

    public static int maxWidth(Component[] componentArray) {
        int n = 0;
        for (Component component : componentArray) {
            int n2 = component.getPreferredSize().width;
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public static void browse(final String string) {
        new Thread(){

            @Override
            public void run() {
                if (desktop != null) {
                    try {
                        desktop.browse(new URI(string));
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(null, exception.toString(), exception.getMessage(), 0);
                    }
                } else {
                    JOptionPane.showMessageDialog(null, Language.get("ERROR_BROWSE_MSG").replaceAll("%u", string), Language.get("ERROR_BROWSE_TITLE"), 2);
                }
            }
        }.start();
    }

    public static void copyFile(File file, File file2) throws IOException {
        FileChannel fileChannel = new FileInputStream(file).getChannel();
        FileChannel fileChannel2 = new FileOutputStream(file2).getChannel();
        try {
            fileChannel.transferTo(0L, fileChannel.size(), fileChannel2);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            if (fileChannel != null) {
                fileChannel.close();
            }
            if (fileChannel2 != null) {
                fileChannel2.close();
            }
        }
    }

    public static void unzip(File file) throws FileNotFoundException, IOException {
        ZipEntry zipEntry;
        ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(file));
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            int n;
            if (System.getProperty("os.name").indexOf("Windows") == -1 && (zipEntry.getName().endsWith("exe") || zipEntry.getName().endsWith("dll"))) continue;
            File file2 = new File(zipEntry.getName());
            System.out.println(file2.getAbsoluteFile());
            if (zipEntry.isDirectory()) {
                file2.mkdirs();
                continue;
            }
            file2.createNewFile();
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            byte[] byArray = new byte[1024];
            while ((n = zipInputStream.read(byArray)) > 0) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
            ((OutputStream)fileOutputStream).close();
        }
    }

    static {
        if (Desktop.isDesktopSupported()) {
            desktop = Desktop.getDesktop();
        }
    }
}

